/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.mixin.Schema;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class FloatSegment
extends AbstractPayloadSegment<Float>
implements Segment {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    public static final int BYTES = 4;
    private Endianess _endianess;

    public FloatSegment(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public FloatSegment(Float aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEndianess());
    }

    public FloatSegment(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public FloatSegment(String aAlias, Float aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEndianess());
    }

    public FloatSegment() {
        this(CaseStyleBuilder.asCamelCase((String)FloatSegment.class.getSimpleName()));
    }

    public FloatSegment(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)FloatSegment.class.getSimpleName()), aEndianess);
    }

    public FloatSegment(Float aValue) {
        this(CaseStyleBuilder.asCamelCase((String)FloatSegment.class.getSimpleName()), aValue);
    }

    public FloatSegment(Float aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)FloatSegment.class.getSimpleName()), aValue, aEndianess);
    }

    public FloatSegment(String aAlias) {
        this(aAlias, Float.valueOf(0.0f), TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public FloatSegment(String aAlias, Endianess aEndianess) {
        this(aAlias, Float.valueOf(0.0f), aEndianess);
    }

    public FloatSegment(String aAlias, Float aValue) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public FloatSegment(String aAlias, Float aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._endianess.toBytes(((Float)this.getPayload()).floatValue()));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, 4);
        this.setPayload(Float.valueOf(this._endianess.toFloat(theRecord)));
        return aOffset + 4;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "" + this.getPayload(), "A body containing an float payload.", new Schema[0]);
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    public FloatSegment withPayload(Float aValue) {
        this.setPayload(aValue);
        return this;
    }
}

