/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.io.BijectiveOutputStream;
import org.refcodes.io.InverseInputStream;
import org.refcodes.numerical.BijectiveFunction;
import org.refcodes.numerical.InverseFunction;
import org.refcodes.numerical.Invertible;
import org.refcodes.serial.AbstractInvertibleTransmissionDecorator;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceInputStream;
import org.refcodes.serial.TransmissionException;

public class InvertibleSegmentDecorator<DECORATEE extends Segment>
extends AbstractInvertibleTransmissionDecorator<DECORATEE>
implements Segment {
    private static final long serialVersionUID = 1L;

    public InvertibleSegmentDecorator(DECORATEE aDecoratee, BijectiveFunction<Byte, Byte> aBijectiveFunction, InverseFunction<Byte, Byte> aInverseFunction) {
        super(aDecoratee, aBijectiveFunction, aInverseFunction);
    }

    public InvertibleSegmentDecorator(DECORATEE aDecoratee, Invertible<Byte, Byte> aInvertible) {
        super(aDecoratee, aInvertible);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        SequenceInputStream theSequenceInputStream = new SequenceInputStream(aSequence, aOffset);
        try {
            this.receiveFrom(theSequenceInputStream);
        }
        catch (IOException e) {
            throw new TransmissionException(e.getMessage(), e);
        }
        return theSequenceInputStream.getOffset();
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        InverseInputStream theInverseInputStream = new InverseInputStream(aInputStream, this._inverseFunction);
        BijectiveOutputStream theBijectiveReturnStream = aReturnStream != null ? new BijectiveOutputStream(aReturnStream, this._bijectiveFunction) : null;
        ((Segment)this._decoratee).receiveFrom((InputStream)theInverseInputStream, (OutputStream)theBijectiveReturnStream);
    }
}

