/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.refcodes.mixin.Schema;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class LongArraySection
extends AbstractPayloadSection<long[]>
implements PayloadSection<long[]> {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    private Endianess _endianess;

    public LongArraySection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public LongArraySection(TransmissionMetrics aTransmissionMetrics, long ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public LongArraySection(TransmissionMetrics aTransmissionMetrics, Long ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public LongArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public LongArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, long ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public LongArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, Long ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public LongArraySection() {
        this(CaseStyleBuilder.asCamelCase((String)LongArraySection.class.getSimpleName()));
    }

    public LongArraySection(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)LongArraySection.class.getSimpleName()));
    }

    public LongArraySection(long ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)LongArraySection.class.getSimpleName()), aValue);
    }

    public LongArraySection(Long ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)LongArraySection.class.getSimpleName()), aValue);
    }

    public LongArraySection(Endianess aEndianess, long ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)LongArraySection.class.getSimpleName()), aEndianess, aValue);
    }

    public LongArraySection(Endianess aEndianess, Long ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)LongArraySection.class.getSimpleName()), aEndianess, LongArraySection.toPrimitiveArray(aValue));
    }

    public LongArraySection(String aAlias) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, new long[0]);
    }

    public LongArraySection(String aAlias, Endianess aEndianess) {
        this(aAlias, aEndianess, new long[0]);
    }

    public LongArraySection(String aAlias, long ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public LongArraySection(String aAlias, Long ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public LongArraySection(String aAlias, Endianess aEndianess, long ... aValue) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    public LongArraySection(String aAlias, Endianess aEndianess, Long ... aValue) {
        super(aAlias, LongArraySection.toPrimitiveArray(aValue));
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        byte[] theBytes = new byte[((long[])this.getPayload()).length * 8];
        for (int i = 0; i < ((long[])this.getPayload()).length; ++i) {
            byte[] eRecord = this._endianess.toBytes(((long[])this.getPayload())[i], 8);
            for (int j = 0; j < eRecord.length; ++j) {
                theBytes[i * 8 + j] = eRecord[j];
            }
        }
        return new ByteArraySequence(theBytes);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (aLength % 8 != 0) {
            throw new TransmissionSequenceException(aSequence, "The length dedicated <" + aLength + "> does not match a multiple long length <8> for retrieving an long array from the given sequence at the offset <" + aOffset + ">!");
        }
        long[] theValues = new long[aLength / 8];
        for (int i = 0; i < theValues.length; ++i) {
            byte[] eRecord = aSequence.toBytes(aOffset + i * 8, 8);
            theValues[i] = this._endianess.toLong(eRecord);
        }
        this.setPayload(theValues);
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? ((long[])this.getPayload()).length * 8 : 0;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "A body containing an long payload.", new Schema[0]);
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((long[])this.getPayload()) + "]";
    }

    public LongArraySection withPayload(long[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(Long[] aPayload) {
        this.setPayload(LongArraySection.toPrimitiveArray(aPayload));
    }

    public LongArraySection withPayload(Long[] aPayload) {
        this.setPayload(LongArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static long[] toPrimitiveArray(Long[] aValue) {
        long[] theResult = new long[aValue.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aValue[i];
        }
        return theResult;
    }
}

