/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.mixin.Schema;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class LongSegment
extends AbstractPayloadSegment<Long>
implements Segment {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    public static final int BYTES = 8;
    private Endianess _endianess;

    public LongSegment(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public LongSegment(Long aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEndianess());
    }

    public LongSegment(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public LongSegment(String aAlias, Long aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEndianess());
    }

    public LongSegment() {
        this(CaseStyleBuilder.asCamelCase((String)LongSegment.class.getSimpleName()));
    }

    public LongSegment(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)LongSegment.class.getSimpleName()), aEndianess);
    }

    public LongSegment(Long aValue) {
        this(CaseStyleBuilder.asCamelCase((String)LongSegment.class.getSimpleName()), aValue);
    }

    public LongSegment(Long aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)LongSegment.class.getSimpleName()), aValue, aEndianess);
    }

    public LongSegment(String aAlias) {
        this(aAlias, (Long)0L, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public LongSegment(String aAlias, Endianess aEndianess) {
        this(aAlias, (Long)0L, aEndianess);
    }

    public LongSegment(String aAlias, Long aValue) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public LongSegment(String aAlias, Long aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._endianess.toBytes(((Long)this.getPayload()).longValue(), 8));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, 8);
        this.setPayload(this._endianess.toLong(theRecord));
        return aOffset + 8;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "" + this.getPayload(), "A body containing an long payload.", new Schema[0]);
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    public LongSegment withPayload(Long aValue) {
        this.setPayload(aValue);
        return this;
    }
}

