/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.AbstractMagicBytesTransmissionDecorator;
import org.refcodes.serial.BadMagicBytesSequenceException;
import org.refcodes.serial.DecoratorSection;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class MagicBytesSectionDecorator<DECORATEE extends Section>
extends AbstractMagicBytesTransmissionDecorator<DECORATEE>
implements Section.SectionMixin,
DecoratorSection<DECORATEE> {
    private static final long serialVersionUID = 1L;

    public MagicBytesSectionDecorator(String aAlias, DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aAlias, aDecoratee, aTransmissionMetrics);
    }

    public MagicBytesSectionDecorator(DECORATEE aDecoratee, int aMagicBytesLength) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSectionDecorator.class.getSimpleName()), aDecoratee, aMagicBytesLength);
    }

    public MagicBytesSectionDecorator(DECORATEE aDecoratee, String aMagicBytes) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSectionDecorator.class.getSimpleName()), aDecoratee, aMagicBytes);
    }

    public MagicBytesSectionDecorator(DECORATEE aDecoratee, String aMagicBytes, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSectionDecorator.class.getSimpleName()), aDecoratee, aMagicBytes);
    }

    public MagicBytesSectionDecorator(DECORATEE aDecoratee, byte[] aMagicBytes) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSectionDecorator.class.getSimpleName()), aDecoratee, aMagicBytes);
    }

    public MagicBytesSectionDecorator(String aAlias, DECORATEE aDecoratee, int aMagicBytesLength) {
        super(aAlias, aDecoratee, aMagicBytesLength);
    }

    public MagicBytesSectionDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    public MagicBytesSectionDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes, Charset aCharset) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    public MagicBytesSectionDecorator(String aAlias, DECORATEE aDecoratee, byte[] aMagicBytes) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws BadMagicBytesSequenceException, TransmissionException {
        this._magicBytes = aSequence.toBytes(aOffset, this._magicBytesLength);
        ((Section)this.getDecoratee()).fromTransmission(aSequence, aOffset += this._magicBytesLength, aLength -= this._magicBytesLength);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException, TransmissionException {
        this._magicBytes = this._magicBytes != null && this._magicBytes.length != this._magicBytesLength ? new byte[this._magicBytesLength] : this._magicBytes;
        aInputStream.read(this._magicBytes);
        ((Section)this.getDecoratee()).receiveFrom(aInputStream, aLength - this._magicBytesLength, aReturnStream);
    }

    public MagicBytesSectionDecorator<DECORATEE> withPayload(byte[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "A section decorator prefixing the encapsulated section with magic bytes.", new Schema[]{((Section)this._decoratee).toSchema()});
        theSchema.put("MAGIC_BYTES", this.getMagicBytes());
        theSchema.put("MAGIC_BYTES_TEXT", this.toMagicBytesString());
        return theSchema;
    }
}

