/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.mixin.Schema;
import org.refcodes.mixin.ValueAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class NumberSegment
extends AbstractPayloadSegment<Long>
implements Segment,
ValueAccessor.ValueProperty<Long>,
ValueAccessor.ValueBuilder<Long, NumberSegment> {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    private Endianess _endianess;
    private int _numberWidth;

    public NumberSegment(int aNumberWidth, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase((String)NumberSegment.class.getSimpleName()), aNumberWidth, aTransmissionMetrics.getEndianess());
    }

    public NumberSegment(int aNumberWidth, Long aValue, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase((String)NumberSegment.class.getSimpleName()), aNumberWidth, aValue, aTransmissionMetrics.getEndianess());
    }

    public NumberSegment(String aAlias, int aNumberWidth, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aNumberWidth, aTransmissionMetrics.getEndianess());
    }

    public NumberSegment(int aNumberWidth) {
        this(CaseStyleBuilder.asCamelCase((String)NumberSegment.class.getSimpleName()), aNumberWidth);
    }

    public NumberSegment(int aNumberWidth, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)NumberSegment.class.getSimpleName()), aNumberWidth, aEndianess);
    }

    public NumberSegment(int aNumberWidth, Long aValue) {
        this(CaseStyleBuilder.asCamelCase((String)NumberSegment.class.getSimpleName()), aNumberWidth, aValue);
    }

    public NumberSegment(int aNumberWidth, Long aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)NumberSegment.class.getSimpleName()), aNumberWidth, aValue, aEndianess);
    }

    public NumberSegment(String aAlias, int aNumberWidth) {
        this(aAlias, aNumberWidth, 0L, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public NumberSegment(String aAlias, int aNumberWidth, Endianess aEndianess) {
        this(aAlias, aNumberWidth, 0L, aEndianess);
    }

    public NumberSegment(String aAlias, int aNumberWidth, Long aValue) {
        this(aAlias, aNumberWidth, aValue, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public NumberSegment(String aAlias, int aNumberWidth, Long aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
        this._numberWidth = aNumberWidth;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._endianess.toBytes(((Long)this.getPayload()).longValue(), this._numberWidth));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, this._numberWidth);
        this.setPayload(this._endianess.toLong(theRecord));
        return aOffset + this._numberWidth;
    }

    @Override
    public int getLength() {
        return this._numberWidth;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "" + this.getPayload(), "A body containing an long payload.", new Schema[0]);
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    public NumberSegment withPayload(Long aValue) {
        this.setPayload(aValue);
        return this;
    }

    public Long getValue() {
        return (Long)this._payload;
    }

    public void setValue(Long aValue) {
        this._payload = aValue;
    }

    public NumberSegment withValue(Long aValue) {
        this.setValue(aValue);
        return this;
    }
}

