/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.refcodes.serial.NoSuchPortExcpetion;
import org.refcodes.serial.Port;
import org.refcodes.serial.PortMetrics;

public interface PortHub<PORT extends Port<PM>, PM extends PortMetrics> {
    public PORT[] ports() throws IOException;

    default public PORT toPort(String aAlias) throws NoSuchPortExcpetion, IOException {
        for (Port ePort : this.ports()) {
            if (ePort.getAlias() != null && ePort.getAlias().equalsIgnoreCase(aAlias)) {
                return (PORT)ePort;
            }
            if (ePort.getAlias() != aAlias) continue;
            return (PORT)ePort;
        }
        throw new NoSuchPortExcpetion(aAlias, "No such port with the given alias <" + aAlias + "> found!");
    }

    default public PORT[] ports(String aPattern) throws IOException {
        Port[] thePortArray;
        String thePortsPattern = aPattern.replace("*", ".*").replace("?", ".");
        ArrayList<Port> thePorts = new ArrayList<Port>();
        for (Port ePort : thePortArray = this.ports()) {
            String ePortName = ePort.getAlias();
            if (thePortsPattern != null && thePortsPattern.length() != 0) {
                if (!ePortName.matches(thePortsPattern)) continue;
                thePorts.add(ePort);
                continue;
            }
            thePorts.add(ePort);
        }
        return thePorts.toArray((Port[])Array.newInstance(thePortArray.getClass().getComponentType(), thePorts.size()));
    }
}

