/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import java.text.ParseException;
import org.refcodes.data.Literal;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.Schema;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.PropertiesImpl;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.EscapeTextBuilder;

public class PropertiesSection
extends AbstractPayloadSection<Properties>
implements Section,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private String _charset;

    public PropertiesSection(Properties aPayload, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase((String)PropertiesSection.class.getSimpleName()), (Properties)new PropertiesImpl(aPayload), aTransmissionMetrics.getEncoding());
    }

    public PropertiesSection(String aAlias, Properties aPayload, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, (Properties)new PropertiesImpl(aPayload), aTransmissionMetrics.getEncoding());
    }

    public PropertiesSection() {
        this(CaseStyleBuilder.asCamelCase((String)PropertiesSection.class.getSimpleName()), (Properties)new PropertiesImpl());
    }

    public PropertiesSection(Properties aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)PropertiesSection.class.getSimpleName()), aPayload);
    }

    public PropertiesSection(Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)PropertiesSection.class.getSimpleName()), (Properties)new PropertiesImpl(), aCharset);
    }

    public PropertiesSection(Properties aPayload, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)PropertiesSection.class.getSimpleName()), (Properties)new PropertiesImpl(aPayload), aCharset);
    }

    public PropertiesSection(String aAlias) {
        this(aAlias, (Properties)new PropertiesImpl(), TransmissionMetrics.DEFAULT_ENCODING);
    }

    public PropertiesSection(String aAlias, Properties aPayload) {
        this(aAlias, aPayload, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public PropertiesSection(String aAlias, Charset aCharset) {
        this(aAlias, (Properties)new PropertiesImpl(), aCharset);
    }

    public PropertiesSection(String aAlias, Properties aPayload, Charset aCharset) {
        super(aAlias, new PropertiesImpl(aPayload));
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
    }

    @Override
    public Sequence toSequence() {
        String serialized = this.toSerialized();
        return new ByteArraySequence(serialized.getBytes(this.getEncoding()));
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, aLength);
        try {
            this.parseFrom(new String(theRecord, this.getEncoding()));
        }
        catch (ParseException e) {
            throw new TransmissionSequenceException(aSequence, "Cannot parse the given sequence: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? this.toSerialized().length() : 0;
    }

    @Override
    public SerialSchema toSchema() {
        String theSerialized = this.toSerialized();
        return new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), theSerialized.length(), theSerialized.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r"), "A body containing a string payload.", new Schema[0]);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._charset == null ? 0 : this._charset.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertiesSection other = (PropertiesSection)obj;
        return !(this._charset == null ? other._charset != null : !this._charset.equals(other._charset));
    }

    public PropertiesSection withPayload(Properties aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return new SimpleTypeMapImpl(this._payload);
    }

    private String toSerialized() {
        StringBuilder theBuilder = new StringBuilder();
        for (String eKey : ((Properties)this.getPayload()).sortedKeys()) {
            String eValue = (String)((Properties)this.getPayload()).get((Object)eKey);
            eValue = EscapeTextBuilder.asEscaped((String)eValue);
            theBuilder.append(eKey);
            theBuilder.append(Literal.EQUALS.getValue());
            theBuilder.append(eValue);
            theBuilder.append('\n');
        }
        return theBuilder.toString();
    }

    private void parseFrom(String aString) throws ParseException {
        if (aString != null && aString.length() != 0) {
            String[] thePairs;
            PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
            for (String eValue : thePairs = aString.split("\n")) {
                String[] eTupel = eValue.split("=", 2);
                theProperties.put((Object)eTupel[0], (Object)EscapeTextBuilder.asUnEscaped((String)eTupel[1]));
            }
            this.setPayload(new PropertiesImpl((Properties)theProperties));
        } else {
            this.setPayload(new PropertiesImpl());
        }
    }

    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }
}

