/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoTimeout;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.serial.AbstractReadyToReceiveTransmissionDecorator;
import org.refcodes.serial.DecoratorSegment;
import org.refcodes.serial.EnquiryStandbyTimeMillisAccessor;
import org.refcodes.serial.FlowControlRetryException;
import org.refcodes.serial.ReadyToReceiveMagicBytesAccessor;
import org.refcodes.serial.ReadyToReceiveRetryNumberAccessor;
import org.refcodes.serial.ReadyToReceiveSegmentPackagerAccessor;
import org.refcodes.serial.ReadyToReceiveTimeoutMillisAccessor;
import org.refcodes.serial.ReadyToReceiveTransmission;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class ReadyToReceiveSegmentDecorator<DECORATEE extends Segment>
extends AbstractReadyToReceiveTransmissionDecorator<DECORATEE>
implements ReadyToReceiveTransmission,
Segment,
DecoratorSegment<DECORATEE> {
    private static final long serialVersionUID = 1L;

    private ReadyToReceiveSegmentDecorator(Builder<DECORATEE> aBuilder) {
        this(aBuilder.decoratee, aBuilder.enquiryStandbyTimeInMs, aBuilder.readyToReceiveMagicBytes, aBuilder.readyToReceiveRetryNumber, aBuilder.readyToReceiveTimeoutInMs, aBuilder.readyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee) {
        super(aDecoratee);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, byte aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, (long)aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, byte aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveMagicBytes, (long)aReadyToReceiveRetryNumber, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, byte aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber) {
        super(aDecoratee, aReadyToReceiveMagicBytes, (long)aReadyToReceiveRetryNumber);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, byte aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, byte aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, byte aReadyToReceiveMagicBytes, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, (long)aReadyToReceiveMagicBytes, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, byte aReadyToReceiveMagicBytes) {
        super(aDecoratee, aReadyToReceiveMagicBytes);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, (int)aReadyToReceiveMagicBytes, (long)aReadyToReceiveRetryNumber, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, (int)aReadyToReceiveMagicBytes, (long)aReadyToReceiveRetryNumber);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, (int)aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, (int)aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte aReadyToReceiveMagicBytes, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, (long)aReadyToReceiveMagicBytes, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte aReadyToReceiveMagicBytes) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, (long)aReadyToReceiveMagicBytes);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs);
    }

    public ReadyToReceiveSegmentDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        return ((Segment)this._decoratee).fromTransmission(aSequence, aOffset);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        if (aReturnStream == null) {
            ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
            return;
        }
        RetryCounter theRetries = new RetryCounter(this._readyToReceiveRetryNumber, this._readyToReceiveTimeoutInMs);
        Exception eException = null;
        TimeoutInputStream theTimeoutInputStream = SerialUtility.createTimeoutInputStream(aInputStream, this._readyToReceiveTimeoutInMs);
        SkipAvailableInputStream theSkipInputStream = new SkipAvailableInputStream(aInputStream, this._readyToReceiveTimeoutInMs);
        while (theRetries.nextRetry()) {
            theSkipInputStream.skipAvailableWithin(IoTimeout.toTimeoutSleepLoopTimeInMs((long)this._readyToReceiveTimeoutInMs));
            eException = null;
            try {
                this._readyToReceiveSegment.transmitTo(aReturnStream);
                ((Segment)this._decoratee).receiveFrom((InputStream)theTimeoutInputStream, aReturnStream);
                return;
            }
            catch (Exception e) {
                eException = e;
            }
        }
        if (eException != null) {
            throw new FlowControlRetryException(this._readyToReceiveRetryNumber, this._readyToReceiveTimeoutInMs, "Aborting after <" + this._readyToReceiveRetryNumber + "> retries with a timeout for each retry of <" + this._readyToReceiveTimeoutInMs + "> milliseconds: " + eException.getMessage(), eException);
        }
        throw new FlowControlRetryException(this._readyToReceiveRetryNumber, this._readyToReceiveTimeoutInMs, "Aborting after <" + this._readyToReceiveRetryNumber + "> retries with a timeout for each retry of <" + this._readyToReceiveTimeoutInMs + "> milliseconds.");
    }

    public static <DECORATEE extends Segment> Builder<DECORATEE> builder() {
        return new Builder();
    }

    public static final class Builder<DECORATEE extends Segment>
    implements DecorateeAccessor.DecorateeBuilder<DECORATEE, Builder<DECORATEE>>,
    EnquiryStandbyTimeMillisAccessor.EnquiryStandbyTimeMillisBuilder<Builder<DECORATEE>>,
    ReadyToReceiveTimeoutMillisAccessor.ReadyToReceiveTimeoutMillisBuilder<Builder<DECORATEE>>,
    ReadyToReceiveMagicBytesAccessor.ReadyToReceiveMagicBytesBuilder<Builder<DECORATEE>>,
    ReadyToReceiveSegmentPackagerAccessor.ReadyToReceiveSegmentPackagerBuilder<Builder<DECORATEE>>,
    ReadyToReceiveRetryNumberAccessor.ReadyToReceiveRetryNumberBuilder<Builder<DECORATEE>> {
        private DECORATEE decoratee;
        private long enquiryStandbyTimeInMs = -1L;
        private long readyToReceiveTimeoutInMs = TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS;
        private byte[] readyToReceiveMagicBytes = TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES;
        private SegmentPackager readyToReceiveSegmentPackager;
        private int readyToReceiveRetryNumber = TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER;

        private Builder() {
        }

        public Builder<DECORATEE> withDecoratee(DECORATEE aDecoratee) {
            this.decoratee = aDecoratee;
            return this;
        }

        @Override
        public Builder<DECORATEE> withEnquiryStandbyTimeMillis(long aEnquiryStandbyTimeInMs) {
            this.enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveTimeoutMillis(long aReadyToReceiveTimeoutInMs) {
            this.readyToReceiveTimeoutInMs = aReadyToReceiveTimeoutInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveMagicBytes(byte[] aReadyToReceiveMagicBytes) {
            this.readyToReceiveMagicBytes = aReadyToReceiveMagicBytes;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveSegmentPackager(SegmentPackager aReadyToReceiveSegmentPackager) {
            this.readyToReceiveSegmentPackager = aReadyToReceiveSegmentPackager;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveRetryNumber(int aReadyToReceiveRetryNumber) {
            this.readyToReceiveRetryNumber = aReadyToReceiveRetryNumber;
            return this;
        }

        public ReadyToReceiveSegmentDecorator<DECORATEE> build() {
            return new ReadyToReceiveSegmentDecorator<Builder>(this);
        }
    }
}

