/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.serial.AbstractReadyToSendTransmissionDecorator;
import org.refcodes.serial.ClearToSendMagicBytesAccessor;
import org.refcodes.serial.ClearToSendSegmentPackagerAccessor;
import org.refcodes.serial.ClearToSendTimeoutMillisAccessor;
import org.refcodes.serial.DecoratorSegment;
import org.refcodes.serial.EnquiryStandbyTimeMillisAccessor;
import org.refcodes.serial.FlowControlTimeoutException;
import org.refcodes.serial.ReadyToSendMagicBytesAccessor;
import org.refcodes.serial.ReadyToSendRetryNumberAccessor;
import org.refcodes.serial.ReadyToSendSegmentPackagerAccessor;
import org.refcodes.serial.ReadyToSendTimeoutMillisAccessor;
import org.refcodes.serial.ReadyToSendTransmission;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class ReadyToSendSegmentDecorator<DECORATEE extends Segment>
extends AbstractReadyToSendTransmissionDecorator<DECORATEE>
implements ReadyToSendTransmission,
Segment,
DecoratorSegment<DECORATEE> {
    private static final long serialVersionUID = 1L;

    private ReadyToSendSegmentDecorator(Builder<DECORATEE> aBuilder) {
        this(aBuilder.decoratee, aBuilder.enquiryStandbyTimeInMs, aBuilder.readyToSendMagicBytes, aBuilder.readyToSendRetryNumber, aBuilder.readyToSendTimeoutInMs, aBuilder.readyToSendSegmentPackager, aBuilder.clearToSendMagicBytes, aBuilder.clearToSendTimeoutInMs, aBuilder.clearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator() {
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, byte[] aClearToSendMagicBytes) {
        super(aDecoratee, aReadyToSendMagicBytes, aClearToSendMagicBytes);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, byte[] aClearToSendMagicBytes) {
        super(aDecoratee, aReadyToSendMagicBytes, aReadyToSendRetryNumber, aClearToSendMagicBytes);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aReadyToSendMagicBytes, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aReadyToSendMagicBytes, aReadyToSendRetryNumber, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs) {
        super(aDecoratee, aReadyToSendMagicBytes, aReadyToSendTimeoutInMs, aClearToSendMagicBytes, aClearToSendTimeoutInMs);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aReadyToSendMagicBytes, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aReadyToSendMagicBytes, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, long aClearToSendTimeoutInMs) {
        super(aDecoratee, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aClearToSendTimeoutInMs);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, byte[] aClearToSendMagicBytes) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aClearToSendMagicBytes);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, byte[] aClearToSendMagicBytes) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendRetryNumber, aClearToSendMagicBytes);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendRetryNumber, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendTimeoutInMs, aClearToSendMagicBytes, aClearToSendTimeoutInMs);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, long aClearToSendTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aClearToSendTimeoutInMs);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToSendTimeoutInMs, long aClearToSendTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendTimeoutInMs, aClearToSendTimeoutInMs);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        super(aDecoratee, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    public ReadyToSendSegmentDecorator(DECORATEE aDecoratee) {
        super(aDecoratee);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        return ((Segment)this._decoratee).fromTransmission(aSequence, aOffset);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        if (aReturnStream == null) {
            ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
            return;
        }
        long theEnquiryStandbyTimeInMs = this._enquiryStandbyTimeInMs;
        long theBeginTimeInMs = System.currentTimeMillis();
        TimeoutInputStream theEnquiryStandbyInputStream = SerialUtility.createTimeoutInputStream(aInputStream, theEnquiryStandbyTimeInMs);
        TimeoutInputStream theTimeoutCtsInputStream = SerialUtility.createTimeoutInputStream(aInputStream, this._clearToSendTimeoutInMs);
        while (theEnquiryStandbyTimeInMs == -1L || theEnquiryStandbyTimeInMs > 0L) {
            try {
                this._readyToSendSegment.receiveFrom((InputStream)theEnquiryStandbyInputStream);
            }
            catch (TimeoutIOException e) {
                throw new FlowControlTimeoutException(e.getTimeoutInMs(), e.getMessage(), e);
            }
            if (Arrays.equals(this._readyToSendMagicBytesSegment.getPayload(), this._readyToSendMagicBytes)) {
                this._clearToSendMagicBytesSegment.transmitTo(aReturnStream);
                ((Segment)this._decoratee).receiveFrom((InputStream)theTimeoutCtsInputStream, aReturnStream);
                return;
            }
            if (theEnquiryStandbyTimeInMs == -1L) continue;
            long eCurrentTimeInMs = System.currentTimeMillis();
            long ePassedTimeInMs = eCurrentTimeInMs - theBeginTimeInMs;
            theBeginTimeInMs = eCurrentTimeInMs;
            if (ePassedTimeInMs < theEnquiryStandbyTimeInMs) {
                theEnquiryStandbyTimeInMs -= ePassedTimeInMs;
                continue;
            }
            throw new FlowControlTimeoutException(this._readyToSendTimeoutInMs, "Failed after a timeout of <" + this._readyToSendTimeoutInMs + "> as the current (received) RTS byte <" + this._readyToSendMagicBytesSegment.getPayload() + "> does not match the expected RTS byte <" + this._readyToSendMagicBytes + ">.");
        }
        throw new FlowControlTimeoutException(this._readyToSendTimeoutInMs, "Failed after a timeout of <" + this._readyToSendTimeoutInMs + "> as the current (received) RTS byte <" + this._readyToSendMagicBytesSegment.getPayload() + "> does not match the expected RTS byte <" + this._readyToSendMagicBytes + ">.");
    }

    public static <DECORATEE extends Segment> Builder<DECORATEE> builder() {
        return new Builder();
    }

    public static final class Builder<DECORATEE extends Segment>
    implements DecorateeAccessor.DecorateeBuilder<DECORATEE, Builder<DECORATEE>>,
    EnquiryStandbyTimeMillisAccessor.EnquiryStandbyTimeMillisBuilder<Builder<DECORATEE>>,
    ReadyToSendTimeoutMillisAccessor.ReadyToSendTimeoutMillisBuilder<Builder<DECORATEE>>,
    ReadyToSendMagicBytesAccessor.ReadyToSendMagicBytesBuilder<Builder<DECORATEE>>,
    ReadyToSendSegmentPackagerAccessor.ReadyToSendSegmentPackagerBuilder<Builder<DECORATEE>>,
    ReadyToSendRetryNumberAccessor.ReadyToSendRetryNumberBuilder<Builder<DECORATEE>>,
    ClearToSendTimeoutMillisAccessor.ClearToSendTimeoutMillisBuilder<Builder<DECORATEE>>,
    ClearToSendMagicBytesAccessor.ClearToSendMagicBytesBuilder<Builder<DECORATEE>>,
    ClearToSendSegmentPackagerAccessor.ClearToSendSegmentPackagerBuilder<Builder<DECORATEE>> {
        private DECORATEE decoratee;
        private long enquiryStandbyTimeInMs = -1L;
        private long clearToSendTimeoutInMs = TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS;
        private byte[] clearToSendMagicBytes = TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES;
        private SegmentPackager clearToSendSegmentPackager;
        private long readyToSendTimeoutInMs = TransmissionMetrics.DEFAULT_READ_TIMEOUT_IN_MS;
        private byte[] readyToSendMagicBytes = TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES;
        private SegmentPackager readyToSendSegmentPackager;
        private int readyToSendRetryNumber = TransmissionMetrics.DEFAULT_READY_TO_SEND_RETRY_NUMBER;

        private Builder() {
        }

        public Builder<DECORATEE> withDecoratee(DECORATEE aDecoratee) {
            this.decoratee = aDecoratee;
            return this;
        }

        @Override
        public Builder<DECORATEE> withEnquiryStandbyTimeMillis(long aEnquiryStandbyTimeInMs) {
            this.enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToSendTimeoutMillis(long aReadyToSendTimeoutInMs) {
            this.readyToSendTimeoutInMs = aReadyToSendTimeoutInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToSendMagicBytes(byte[] aReadyToSendMagicBytes) {
            this.readyToSendMagicBytes = aReadyToSendMagicBytes;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToSendSegmentPackager(SegmentPackager aReadyToSendSegmentPackager) {
            this.readyToSendSegmentPackager = aReadyToSendSegmentPackager;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToSendRetryNumber(int aReadyToSendRetryNumber) {
            this.readyToSendRetryNumber = aReadyToSendRetryNumber;
            return this;
        }

        @Override
        public Builder<DECORATEE> withClearToSendTimeoutMillis(long aClearToSendTimeoutInMs) {
            this.clearToSendTimeoutInMs = aClearToSendTimeoutInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withClearToSendMagicBytes(byte[] aClearToSendMagicBytes) {
            this.clearToSendMagicBytes = aClearToSendMagicBytes;
            return this;
        }

        @Override
        public Builder<DECORATEE> withClearToSendSegmentPackager(SegmentPackager aClearToSendSegmentPackager) {
            this.clearToSendSegmentPackager = aClearToSendSegmentPackager;
            return this;
        }

        public ReadyToSendSegmentDecorator<DECORATEE> build() {
            return new ReadyToSendSegmentDecorator<Builder>(this);
        }
    }
}

