/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.Clearable;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.InputStreamAccessor;
import org.refcodes.mixin.LengthAccessor;
import org.refcodes.mixin.OutputStreamAccessor;
import org.refcodes.mixin.TruncateMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.SequenceInputStream;
import org.refcodes.serial.SequenceOutputStream;

public interface Sequence
extends LengthAccessor,
Iterable<Byte>,
InputStreamAccessor,
OutputStreamAccessor,
Clearable {
    default public void append(byte ... aBytes) {
        this.append(aBytes, 0, aBytes.length);
    }

    public void append(byte[] var1, int var2, int var3);

    public void append(Sequence var1);

    default public void clear() {
        this.clear((byte)0);
    }

    default public void clear(byte aValue) {
        for (int i = 0; i < this.getLength(); ++i) {
            this.setByteAt(i, (byte)0);
        }
    }

    default public void concatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        switch (aConcatenateMode) {
            case PREPEND: {
                this.prepend(aBytes);
                return;
            }
            case APPEND: {
                this.append(aBytes);
                return;
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    default public void concatenate(ConcatenateMode aConcatenateMode, byte[] aBytes, int aOffset, int aLength) {
        switch (aConcatenateMode) {
            case PREPEND: {
                this.prepend(aBytes, aOffset, aLength);
                return;
            }
            case APPEND: {
                this.append(aBytes, aOffset, aLength);
                return;
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    default public void concatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        switch (aConcatenateMode) {
            case PREPEND: {
                this.prepend(aSequence);
                return;
            }
            case APPEND: {
                this.append(aSequence);
                return;
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    public void empty();

    public byte getByteAt(int var1) throws IndexOutOfBoundsException;

    default public InputStream getInputStream() {
        return new SequenceInputStream(this);
    }

    default public OutputStream getOutputStream() {
        return new SequenceOutputStream(this);
    }

    default public void overwrite(byte[] aBytes) {
        this.overwrite(0, aBytes, 0, aBytes.length);
    }

    default public void overwrite(byte[] aBytes, int aLength) {
        this.overwrite(0, aBytes, 0, aLength);
    }

    default public void overwrite(int aOffset, byte[] aBytes) {
        this.overwrite(aOffset, aBytes, 0, aBytes.length);
    }

    default public void overwrite(int aOffset, byte[] aBytes, int aBytesOffset, int aLength) {
        int theDeltaLength = aOffset + aLength - this.getLength();
        if (theDeltaLength > 0) {
            this.append(new byte[theDeltaLength]);
        }
        for (int i = 0; i < aLength; ++i) {
            this.setByteAt(aOffset + i, aBytes[i + aBytesOffset]);
        }
    }

    default public void overwrite(int aOffset, Sequence aSequence) {
        byte[] theBytes = aSequence.toBytes();
        this.overwrite(aOffset, theBytes, 0, theBytes.length);
    }

    default public void overwrite(int aOffset, Sequence aSequence, int aSequenceOffset, int aLength) {
        int theDeltaLength = aOffset + aLength - this.getLength();
        if (theDeltaLength > 0) {
            this.append(new byte[theDeltaLength]);
        }
        for (int i = 0; i < aLength; ++i) {
            this.setByteAt(aOffset + i, aSequence.getByteAt(i + aSequenceOffset));
        }
    }

    default public void overwrite(Sequence aSequence) {
        byte[] theBytes = aSequence.toBytes();
        this.overwrite(0, theBytes, 0, theBytes.length);
    }

    default public void overwrite(Sequence aSequence, int aLength) {
        this.overwrite(0, aSequence, 0, aLength);
    }

    default public void prepend(byte ... aBytes) {
        this.prepend(aBytes, 0, aBytes.length);
    }

    public void prepend(byte[] var1, int var2, int var3);

    public void prepend(Sequence var1);

    default public void replace(byte[] aBytes) {
        this.replace(aBytes, 0, aBytes.length);
    }

    default public void replace(byte[] aBytes, int aLength) {
        this.replace(aBytes, 0, aLength);
    }

    public void replace(byte[] var1, int var2, int var3);

    default public void replace(Sequence aSequence) {
        this.replace(aSequence, 0, aSequence.getLength());
    }

    default public void replace(Sequence aSequence, int aLength) {
        this.replace(aSequence, 0, aLength);
    }

    public void replace(Sequence var1, int var2, int var3);

    public void setByteAt(int var1, byte var2);

    default public Sequence toAppend(byte ... aBytes) {
        return this.toAppend(aBytes, 0, aBytes.length);
    }

    public Sequence toAppend(byte[] var1, int var2, int var3);

    public Sequence toAppend(Sequence var1);

    default public byte[] toBytes() {
        byte[] theBytes = new byte[this.getLength()];
        for (int i = 0; i < theBytes.length; ++i) {
            theBytes[i] = this.getByteAt(i);
        }
        return theBytes;
    }

    default public byte[] toBytes(int aOffset, int aLength) {
        byte[] theChunk = new byte[aLength];
        for (int i = 0; i < theChunk.length; ++i) {
            theChunk[i] = this.getByteAt(aOffset + i);
        }
        return theChunk;
    }

    default public void toBytes(int aOffset, int aLength, byte[] aBytes, int aBytesOffset) {
        for (int i = 0; i < aLength; ++i) {
            aBytes[i + aBytesOffset] = this.getByteAt(aOffset + i);
        }
    }

    public Sequence toClone();

    default public Sequence toConcatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        switch (aConcatenateMode) {
            case PREPEND: {
                return this.toPrepend(aBytes);
            }
            case APPEND: {
                return this.toAppend(aBytes);
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    default public Sequence toConcatenate(ConcatenateMode aConcatenateMode, byte[] aBytes, int aOffset, int aLength) {
        switch (aConcatenateMode) {
            case PREPEND: {
                return this.toPrepend(aBytes, aOffset, aLength);
            }
            case APPEND: {
                return this.toAppend(aBytes, aOffset, aLength);
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    default public Sequence toConcatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        switch (aConcatenateMode) {
            case PREPEND: {
                return this.toPrepend(aSequence);
            }
            case APPEND: {
                return this.toAppend(aSequence);
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    public byte[] toCrcBytes(CrcAlgorithm var1, Endianess var2);

    public byte[] toCrcBytes(long var1, CrcAlgorithm var3, Endianess var4);

    public long toCrcChecksum(CrcAlgorithm var1);

    public long toCrcChecksum(long var1, CrcAlgorithm var3);

    default public String toHexString() {
        return this.toHexString(" ");
    }

    default public String toHexString(String aSeparator) {
        int theSize = this.getLength();
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < theSize; ++i) {
            theBuffer.append(NumericalUtility.toHexString((byte)this.getByteAt(i)));
            if (i >= theSize - 1) continue;
            theBuffer.append(aSeparator);
        }
        return theBuffer.toString();
    }

    default public InputStream toInputStream() {
        return new ByteArraySequence((byte[])this.toBytes().clone()).getInputStream();
    }

    default public Sequence toOverwrite(byte[] aBytes) {
        return this.toOverwrite(0, aBytes, 0, aBytes.length);
    }

    default public Sequence toOverwrite(byte[] aBytes, int aLength) {
        return this.toOverwrite(0, aBytes, 0, aLength);
    }

    default public Sequence toOverwrite(int aOffset, byte[] aBytes) {
        return this.toOverwrite(aOffset, aBytes, 0, aBytes.length);
    }

    public Sequence toOverwrite(int var1, byte[] var2, int var3, int var4);

    default public Sequence toOverwrite(int aOffset, Sequence aSequence) {
        return this.toOverwrite(aOffset, aSequence, 0, aSequence.getLength());
    }

    public Sequence toOverwrite(int var1, Sequence var2, int var3, int var4);

    default public Sequence toOverwrite(Sequence aSequence) {
        return this.toOverwrite(0, aSequence, 0, aSequence.getLength());
    }

    default public Sequence toOverwrite(Sequence aSequence, int aLength) {
        return this.toOverwrite(0, aSequence, 0, aLength);
    }

    default public Sequence toPrepend(byte ... aBytes) {
        return this.toPrepend(aBytes, 0, aBytes.length);
    }

    public Sequence toPrepend(byte[] var1, int var2, int var3);

    public Sequence toPrepend(Sequence var1);

    public Sequence toSequence(int var1, int var2);

    default public Sequence toTruncate(int aLength, TruncateMode aTruncateMode) {
        Sequence theSequence = null;
        if (aTruncateMode.isHead()) {
            theSequence = this.toTruncateHead(aLength);
        }
        if (aTruncateMode.isTail()) {
            if (theSequence == null) {
                theSequence = this.toTruncateTail(aLength);
            } else {
                theSequence.truncateTail(aLength);
            }
        }
        return theSequence;
    }

    public Sequence toTruncateHead(int var1);

    public Sequence toTruncateTail(int var1);

    default public void truncate(int aLength, TruncateMode aTruncateMode) {
        if (aTruncateMode.isHead()) {
            this.truncateHead(aLength);
        }
        if (aTruncateMode.isTail()) {
            this.truncateTail(aLength);
        }
    }

    public void truncateHead(int var1);

    public void truncateTail(int var1);

    default public Sequence withAppend(byte ... aBytes) {
        this.append(aBytes);
        return this;
    }

    default public Sequence withAppend(byte[] aBytes, int aOffset, int aLength) {
        this.append(aBytes, aOffset, aLength);
        return this;
    }

    default public Sequence withAppend(Sequence aSequence) {
        this.append(aSequence);
        return this;
    }

    default public Sequence withConcatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        this.concatenate(aConcatenateMode, aBytes);
        return this;
    }

    default public Sequence withConcatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        this.prepend(aSequence);
        return this;
    }

    default public Sequence withOverwrite(byte[] aBytes) {
        this.overwrite(0, aBytes);
        return this;
    }

    default public Sequence withOverwrite(byte[] aBytes, int aLength) {
        this.overwrite(aBytes, aLength);
        return this;
    }

    default public Sequence withOverwrite(int aOffset, byte[] aBytes) {
        this.overwrite(aOffset, aBytes);
        return this;
    }

    default public Sequence withOverwrite(int aOffset, byte[] aBytes, int aBytesOffset, int aLength) {
        this.overwrite(aOffset, aBytes, aBytesOffset, aLength);
        return this;
    }

    default public Sequence withOverwrite(int aOffset, Sequence aSequence) {
        this.overwrite(aOffset, aSequence);
        return this;
    }

    default public Sequence withOverwrite(int aOffset, Sequence aSequence, int aSequenceOffset, int aLength) {
        this.overwrite(aOffset, aSequence, aSequenceOffset, aLength);
        return this;
    }

    default public Sequence withOverwrite(Sequence aSequence) {
        this.overwrite(0, aSequence);
        return this;
    }

    default public Sequence withOverwrite(Sequence aSequence, int aLength) {
        this.overwrite(aSequence, aLength);
        return this;
    }

    default public Sequence withPrepend(byte ... aBytes) {
        this.prepend(aBytes);
        return this;
    }

    default public Sequence withPrepend(byte[] aBytes, int aOffset, int aLength) {
        this.prepend(aBytes, aOffset, aLength);
        return this;
    }

    default public Sequence withPrepend(Sequence aSequence) {
        this.prepend(aSequence);
        return this;
    }

    default public Sequence withReplace(byte[] aBytes) {
        this.replace(aBytes);
        return this;
    }

    default public Sequence withReplace(byte[] aBytes, int aLength) {
        this.replace(aBytes, 0, aLength);
        return this;
    }

    default public Sequence withReplace(Sequence aSequence, int aLength) {
        this.replace(aSequence, 0, aLength);
        return this;
    }

    default public Sequence withReplace(byte[] aBytes, int aOffset, int aLength) {
        this.replace(aBytes, aOffset, aLength);
        return this;
    }

    default public Sequence withReplace(Sequence aSequence) {
        this.replace(aSequence);
        return this;
    }

    default public Sequence withReplace(Sequence aSequence, int aOffset, int aLength) {
        this.replace(aSequence, aOffset, aLength);
        return this;
    }

    default public Sequence withTruncate(int aLength, TruncateMode aTruncateMode) {
        this.truncate(aLength, aTruncateMode);
        return this;
    }

    default public Sequence withTruncateHead(int aLength) {
        this.truncateHead(aLength);
        return this;
    }

    default public Sequence withTruncateTail(int aLength) {
        this.truncateTail(aLength);
        return this;
    }

    public void writeTo(OutputStream var1) throws IOException;
}

