/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.refcodes.factory.TypeFactory;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.LengthWidthAccessor;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Section;
import org.refcodes.serial.SectionComposite;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapBuilderImpl;
import org.refcodes.textual.CaseStyleBuilder;

public class StringArraySection
implements Section.SectionMixin,
PayloadSection<String[]>,
LengthWidthAccessor,
EndianessAccessor,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private SectionComposite<AllocSectionDecoratorSegment<StringSection>, StringSection> _arraySegment;
    private TypeFactory<StringSection> _segmentFactory;
    private TypeFactory<AllocSectionDecoratorSegment<StringSection>> _allocSegmentFactory;
    private int _lengthWidth;
    private Endianess _endianess;
    private String _charset = TransmissionMetrics.DEFAULT_ENCODING.name();
    private String _alias;

    public StringArraySection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), new String[0]);
    }

    public StringArraySection(TransmissionMetrics aTransmissionMetrics, String ... aValue) {
        this(aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), aValue);
    }

    public StringArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), new String[0]);
    }

    public StringArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, String ... aValue) {
        this(aAlias, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding(), aValue);
    }

    public StringArraySection() {
        this(CaseStyleBuilder.asCamelCase((String)StringArraySection.class.getSimpleName()));
    }

    public StringArraySection(String ... aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)StringArraySection.class.getSimpleName()), aPayload);
    }

    public StringArraySection(Charset aCharset, String ... aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)StringArraySection.class.getSimpleName()), aCharset, aPayload);
    }

    public StringArraySection(int aLengthWidth, Endianess aEndianess, Charset aCharset, String ... aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)StringArraySection.class.getSimpleName()), aLengthWidth, aEndianess, aCharset, aPayload);
    }

    public StringArraySection(String aAlias) {
        this(aAlias, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, new String[0]);
    }

    public StringArraySection(String aAlias, String[] aPayload) {
        this(aAlias, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, aPayload);
    }

    public StringArraySection(String aAlias, Charset aCharset, String ... aPayload) {
        this(aAlias, 4, TransmissionMetrics.DEFAULT_ENDIANESS, aCharset, aPayload);
    }

    public StringArraySection(String aAlias, final int aLengthWidth, final Endianess aEndianess, final Charset aCharset, String ... aPayload) {
        this._alias = aAlias;
        this._lengthWidth = aLengthWidth;
        this._endianess = aEndianess;
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
        this._segmentFactory = new TypeFactory<StringSection>(){

            public StringSection createInstance() {
                return new StringSection(aCharset);
            }

            public Class<StringSection> getType() {
                return StringSection.class;
            }
        };
        this._allocSegmentFactory = new TypeFactory<AllocSectionDecoratorSegment<StringSection>>(){

            public AllocSectionDecoratorSegment<StringSection> createInstance() {
                return new AllocSectionDecoratorSegment<StringSection>(aLengthWidth, aEndianess);
            }
        };
        this.setPayload(aPayload);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        this._arraySegment.fromTransmission(aSequence, aOffset, aLength);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException, TransmissionException {
        this._arraySegment.receiveFrom(aInputStream, aLength, aReturnStream);
    }

    @Override
    public Sequence toSequence() {
        return this._arraySegment.toSequence();
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = this._arraySegment.toSchema();
        theSchema.put("ALIAS", this._alias);
        return theSchema;
    }

    @Override
    public int getLength() {
        return this._arraySegment.getLength();
    }

    public String[] getPayload() {
        String[] theStrings = null;
        if (this._arraySegment != null) {
            StringSection[] theSegments = (StringSection[])this._arraySegment.getChildren();
            theStrings = new String[theSegments.length];
            for (int i = 0; i < theSegments.length; ++i) {
                theStrings[i] = (String)theSegments[i].getPayload();
            }
        }
        return theStrings;
    }

    public void setPayload(String[] aValue) {
        this._arraySegment = aValue != null ? new SectionComposite(this._allocSegmentFactory, this._segmentFactory, (Section[])this.toStringBodyArray(aValue, this.getEncoding())) : new SectionComposite<AllocSectionDecoratorSegment<StringSection>, StringSection>(this._allocSegmentFactory, this._segmentFactory);
    }

    public StringArraySection withPayload(String[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public int getLengthWidth() {
        return this._lengthWidth;
    }

    public Endianess getEndianess() {
        return this._endianess;
    }

    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }

    public String getAlias() {
        return this._alias;
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return new SimpleTypeMapBuilderImpl().withInsertTo(this._alias, (Object)this.getPayload());
    }

    private StringSection[] toStringBodyArray(String[] aArray, Charset aCharset) {
        StringSection[] theArray = new StringSection[aArray.length];
        for (int i = 0; i < aArray.length; ++i) {
            theArray[i] = new StringSection(aArray[i], aCharset);
        }
        return theArray;
    }
}

