/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class StringSection
extends AbstractPayloadSection<String>
implements PayloadSection<String>,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private String _charset;

    public StringSection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEncoding());
    }

    public StringSection(String aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEncoding());
    }

    public StringSection(String aAlias, String aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEncoding());
    }

    public StringSection() {
        this(CaseStyleBuilder.asCamelCase((String)StringSection.class.getSimpleName()), (String)null);
    }

    public StringSection(String aValue) {
        this(CaseStyleBuilder.asCamelCase((String)StringSection.class.getSimpleName()), aValue);
    }

    public StringSection(Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)StringSection.class.getSimpleName()), null, aCharset);
    }

    public StringSection(String aValue, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)StringSection.class.getSimpleName()), aValue, aCharset);
    }

    public StringSection(String aAlias, String aValue) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public StringSection(String aAlias, String aValue, Charset aCharset) {
        super(aAlias, aValue);
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
    }

    @Override
    public Sequence toSequence() {
        if (this.getPayload() != null) {
            return new ByteArraySequence(((String)this.getPayload()).getBytes(this.getEncoding()));
        }
        return new ByteArraySequence();
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, aLength);
        super.setPayload(new String(theRecord, this.getEncoding()));
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? this.toSequence().getLength() : 0;
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), (String)this.getPayload(), "A section containing a string payload.", new Schema[0]);
    }

    public StringSection withPayload(String aValue) {
        this.setPayload(aValue);
        return this;
    }

    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }
}

