/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.mixin.LengthAccessor;
import org.refcodes.mixin.Schemable;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.struct.SimpleTypeMap;

public interface Transmission
extends LengthAccessor,
Serializable,
Schemable {
    public int getLength();

    public Sequence toSequence();

    default public void transmitTo(OutputStream aOutputStream) throws IOException {
        this.transmitTo(aOutputStream, null);
    }

    default public void transmitTo(SerialTransceiver aSerialTransceiver) throws IOException {
        this.transmitTo(aSerialTransceiver.getOutputStream(), aSerialTransceiver.getInputStream());
    }

    public void transmitTo(OutputStream var1, InputStream var2) throws IOException;

    public SerialSchema toSchema();

    public SimpleTypeMap toSimpleTypeMap();

    public static byte[] fromInputStream(InputStream aInputStream, int aLength) throws IOException {
        int theProcessedLength;
        byte[] theChunk = new byte[aLength];
        int theRemainingLength = aLength;
        RetryCounter theRetries = new RetryCounter(IoRetryCount.NORM.getValue().intValue());
        int eRead = 0;
        for (theProcessedLength = 0; theProcessedLength < aLength && theRetries.nextRetry(); theProcessedLength += eRead) {
            try {
                eRead = aInputStream.read(theChunk, theProcessedLength, theRemainingLength);
            }
            catch (IOException e) {
                throw new IOException("Can only retrieve <" + theProcessedLength + "> of the expected <" + aLength + "> number of bytes: " + e.getMessage(), e);
            }
            eRead = eRead < 0 ? 0 : eRead;
            theRemainingLength -= eRead;
        }
        if (theProcessedLength < aLength) {
            throw new IOException("Can only retrieve <" + theProcessedLength + "> of the expected <" + aLength + "> number of bytes after <" + theRetries.getRetryCount() + "> retries!");
        }
        return theChunk;
    }

    public static interface TransmissionMixin
    extends Transmission {
        @Override
        default public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
            Sequence theSequence = this.toSequence();
            Iterator iterator = theSequence.iterator();
            while (iterator.hasNext()) {
                byte eByte = (Byte)iterator.next();
                aOutputStream.write(eByte);
            }
            aOutputStream.flush();
        }
    }
}

