/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.servicebus.impls;

import org.refcodes.component.consts.LifeCycleStatus;
import org.refcodes.component.ext.observer.LifeCycleObserver;
import org.refcodes.component.ext.observer.ObservableLifeCycleAutomaton;
import org.refcodes.component.ext.observer.consts.LifeCycleRequest;
import org.refcodes.component.ext.observer.events.DestroyedEvent;
import org.refcodes.component.ext.observer.events.InitializedEvent;
import org.refcodes.component.ext.observer.events.LifeCycleEvent;
import org.refcodes.component.ext.observer.events.PausedEvent;
import org.refcodes.component.ext.observer.events.ResumedEvent;
import org.refcodes.component.ext.observer.events.StartedEvent;
import org.refcodes.component.ext.observer.events.StoppedEvent;
import org.refcodes.component.traps.InitializeException;
import org.refcodes.component.traps.PauseException;
import org.refcodes.component.traps.ResumeException;
import org.refcodes.component.traps.StartException;
import org.refcodes.component.traps.StopException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.factories.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.servicebus.Service;
import org.refcodes.servicebus.ServiceBus;
import org.refcodes.servicebus.ServiceContext;
import org.refcodes.servicebus.ServiceDescriptor;
import org.refcodes.servicebus.ServiceLookup;
import org.refcodes.servicebus.ServiceMatcher;
import org.refcodes.servicebus.traps.AmbiguousServiceRuntimeException;
import org.refcodes.servicebus.traps.NoMatchingServiceRuntimeException;

public class ServiceBusImpl<S extends Service<?>, SCTX extends ServiceContext<S>>
implements ServiceBus<S> {
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private ServiceLookup<S, SCTX> _serviceLookup;
    private ServiceBusObserver _serviceBusObserver = new ServiceBusObserver();

    public ServiceBusImpl(ServiceLookup<S, SCTX> aServiceLookup, ObservableLifeCycleAutomaton aObservableLifecycleAutomaton) {
        assert (aServiceLookup != null);
        assert (aObservableLifecycleAutomaton != null);
        this._serviceLookup = aServiceLookup;
        this.registerLifecycleEventDispatcher(aObservableLifecycleAutomaton);
    }

    @Override
    public S lookupService(ServiceMatcher<S> aServiceMatcher) throws NoMatchingServiceRuntimeException, AmbiguousServiceRuntimeException {
        assert (aServiceMatcher != null);
        S theMatchedService = null;
        for (ServiceDescriptor<S, SCTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            Object eService = theServiceDescriptor.getService();
            if (!aServiceMatcher.isMatching(eService)) continue;
            if (theMatchedService != null) {
                throw new AmbiguousServiceRuntimeException(aServiceMatcher, "The given service matcher matched more than one service.");
            }
            theMatchedService = eService;
        }
        if (theMatchedService == null) {
            throw new NoMatchingServiceRuntimeException(aServiceMatcher, "A service for the given matcher is not known by this service bus.");
        }
        return theMatchedService;
    }

    @Override
    public boolean hasService(ServiceMatcher<S> aServiceMatcher) {
        assert (aServiceMatcher != null);
        boolean hasMatchedService = false;
        for (ServiceDescriptor<S, SCTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            Object eService = theServiceDescriptor.getService();
            if (!aServiceMatcher.isMatching(eService)) continue;
            if (hasMatchedService) {
                return false;
            }
            hasMatchedService = true;
        }
        return hasMatchedService;
    }

    protected void registerLifecycleEventDispatcher(ObservableLifeCycleAutomaton aObservableLifecycleAutomaton) {
        aObservableLifecycleAutomaton.subscribeObserver((Object)this._serviceBusObserver);
    }

    protected void onLifecycleEvent(LifeCycleEvent.LifeCycleRequestEvent aEvent) {
        switch (aEvent.getLifeCycleRequest()) {
            case INITIALIZE: {
                this.initializeServices();
                break;
            }
            case START: {
                this.startServices();
                break;
            }
            case PAUSE: {
                this.pauseServices();
                break;
            }
            case RESUME: {
                this.resumeServices();
                break;
            }
            case STOP: {
                this.stopServices();
                break;
            }
            case DESTROY: {
                this.destroyServices();
            }
        }
    }

    protected void initializeServices() {
        LOGGER.info("About to " + LifeCycleRequest.INITIALIZE + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isInitalizable()) continue;
            try {
                eServiceLifecycle.initialize();
            }
            catch (InitializeException e) {
                LOGGER.warn("Unable to \"" + LifeCycleRequest.INITIALIZE + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", (Throwable)e);
            }
        }
        LOGGER.info("Services \"" + LifeCycleStatus.INITIALIZED + "\".");
    }

    protected void startServices() {
        LOGGER.info("About to " + LifeCycleRequest.START + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isStartable()) continue;
            try {
                eServiceLifecycle.start();
            }
            catch (StartException e) {
                LOGGER.warn("Unable to \"" + LifeCycleRequest.START + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", (Throwable)e);
            }
        }
        LOGGER.info("Services \"" + LifeCycleStatus.RUNNING + "\".");
    }

    protected void pauseServices() {
        LOGGER.info("About to " + LifeCycleRequest.PAUSE + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isPausable()) continue;
            try {
                eServiceLifecycle.pause();
            }
            catch (PauseException e) {
                LOGGER.warn("Unable to \"" + LifeCycleRequest.PAUSE + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", (Throwable)e);
            }
        }
        LOGGER.info("Services \"" + LifeCycleStatus.PAUSED + "\".");
    }

    protected void resumeServices() {
        LOGGER.info("About to " + LifeCycleRequest.RESUME + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isResumable()) continue;
            try {
                eServiceLifecycle.resume();
            }
            catch (ResumeException e) {
                LOGGER.warn("Unable to \"" + LifeCycleRequest.RESUME + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", (Throwable)e);
            }
        }
        LOGGER.info("Services \"" + LifeCycleStatus.RUNNING + "\".");
    }

    protected void stopServices() {
        LOGGER.info("About to " + LifeCycleRequest.STOP + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isStoppable()) continue;
            try {
                eServiceLifecycle.stop();
            }
            catch (StopException e) {
                LOGGER.warn("Unable to \"" + LifeCycleRequest.STOP + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", (Throwable)e);
            }
        }
        LOGGER.info("Services \"" + LifeCycleStatus.STOPPED + "\".");
    }

    protected void destroyServices() {
        LOGGER.info("About to " + LifeCycleRequest.DESTROY + " services ...");
        for (ServiceDescriptor<S, SCTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleAutomaton theServiceLifecycle = ((ServiceContext)theServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!theServiceLifecycle.isDestroyable()) continue;
            theServiceLifecycle.destroy();
        }
        LOGGER.info("Services \"" + LifeCycleStatus.DESTROYED + "\".");
    }

    private class ServiceBusObserver
    implements LifeCycleObserver {
        private ServiceBusObserver() {
        }

        public void onEvent(LifeCycleEvent aEvent) {
            throw new RuntimeException("*** NOT YET IMPLEMENTED ***");
        }

        public void onInitialized(InitializedEvent aEvent) {
            throw new RuntimeException("*** NOT YET IMPLEMENTED ***");
        }

        public void onStarted(StartedEvent aEvent) {
            throw new RuntimeException("*** NOT YET IMPLEMENTED ***");
        }

        public void onResumed(ResumedEvent aEvent) {
            throw new RuntimeException("*** NOT YET IMPLEMENTED ***");
        }

        public void onPaused(PausedEvent aEvent) {
            throw new RuntimeException("*** NOT YET IMPLEMENTED ***");
        }

        public void onStopped(StoppedEvent aEvent) {
            throw new RuntimeException("*** NOT YET IMPLEMENTED ***");
        }

        public void onDestroyed(DestroyedEvent aEvent) {
            throw new RuntimeException("*** NOT YET IMPLEMENTED ***");
        }
    }
}

