/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.servicebus.impls;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.refcodes.servicebus.Service;
import org.refcodes.servicebus.ServiceContext;
import org.refcodes.servicebus.ServiceDescriptor;
import org.refcodes.servicebus.ServiceDirectory;
import org.refcodes.servicebus.traps.DuplicateServiceRuntimeException;
import org.refcodes.servicebus.traps.UnknownServiceRuntimeException;

public class ServiceDirectoryImpl<S extends Service<?>, SCTX extends ServiceContext<S>>
implements ServiceDirectory<S, SCTX> {
    private Set<ServiceDescriptor<S, SCTX>> _serviceDescriptors = new HashSet<ServiceDescriptor<S, SCTX>>();

    @Override
    public Set<ServiceDescriptor<S, SCTX>> getServiceDescriptors() {
        return Collections.unmodifiableSet(this._serviceDescriptors);
    }

    @Override
    public boolean hasService(ServiceDescriptor<S, SCTX> aServiceDescriptor) {
        return this._serviceDescriptors.contains(aServiceDescriptor);
    }

    @Override
    public void addService(ServiceDescriptor<S, SCTX> aServiceDescriptor) throws DuplicateServiceRuntimeException {
        if (this.hasService(aServiceDescriptor)) {
            throw new DuplicateServiceRuntimeException((Service<?>)aServiceDescriptor.getService(), "The given service descriptor is already known by service type and by service meta data.");
        }
        this._serviceDescriptors.add(aServiceDescriptor);
    }

    @Override
    public void removeService(ServiceDescriptor<S, SCTX> aServiceDescriptor) throws UnknownServiceRuntimeException {
        boolean isRemoved = this._serviceDescriptors.remove(aServiceDescriptor);
        if (!isRemoved) {
            throw new UnknownServiceRuntimeException((Service<?>)aServiceDescriptor.getService(), "The given service is not know by service type and by service meta data.");
        }
    }
}

