/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.servicebus;

import org.refcodes.component.InitializeException;
import org.refcodes.component.LifeCycleRequest;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.component.ext.observer.DestroyedEvent;
import org.refcodes.component.ext.observer.InitializedEvent;
import org.refcodes.component.ext.observer.LifeCycleRequestEvent;
import org.refcodes.component.ext.observer.LifeCycleStatusObserver;
import org.refcodes.component.ext.observer.ObservableLifeCycleStatusAutomaton;
import org.refcodes.component.ext.observer.PausedEvent;
import org.refcodes.component.ext.observer.ResumedEvent;
import org.refcodes.component.ext.observer.StartedEvent;
import org.refcodes.component.ext.observer.StoppedEvent;
import org.refcodes.data.Text;
import org.refcodes.mixin.Loggable;
import org.refcodes.servicebus.AmbiguousServiceRuntimeException;
import org.refcodes.servicebus.NoMatchingServiceRuntimeException;
import org.refcodes.servicebus.Service;
import org.refcodes.servicebus.ServiceBus;
import org.refcodes.servicebus.ServiceContext;
import org.refcodes.servicebus.ServiceDescriptor;
import org.refcodes.servicebus.ServiceLookup;
import org.refcodes.servicebus.ServiceMatcher;

public class ServiceBusImpl<S extends Service<?>, SCTX extends ServiceContext<S>>
implements ServiceBus<S>,
Loggable {
    private ServiceLookup<S, SCTX> _serviceLookup;
    private ServiceBusObserver _serviceBusObserver = new ServiceBusObserver();

    public ServiceBusImpl(ServiceLookup<S, SCTX> aServiceLookup, ObservableLifeCycleStatusAutomaton aObservableLifecycleAutomaton) {
        assert (aServiceLookup != null);
        assert (aObservableLifecycleAutomaton != null);
        this._serviceLookup = aServiceLookup;
        this.registerLifecycleEventDispatcher(aObservableLifecycleAutomaton);
    }

    @Override
    public S lookupService(ServiceMatcher<S> aServiceMatcher) throws NoMatchingServiceRuntimeException, AmbiguousServiceRuntimeException {
        assert (aServiceMatcher != null);
        S theMatchedService = null;
        for (ServiceDescriptor<S, SCTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            Object eService = theServiceDescriptor.getService();
            if (!aServiceMatcher.isMatching(eService)) continue;
            if (theMatchedService != null) {
                throw new AmbiguousServiceRuntimeException(aServiceMatcher, "The given service matcher matched more than one service.");
            }
            theMatchedService = eService;
        }
        if (theMatchedService == null) {
            throw new NoMatchingServiceRuntimeException(aServiceMatcher, "A service for the given matcher is not known by this service bus.");
        }
        return theMatchedService;
    }

    @Override
    public boolean hasService(ServiceMatcher<S> aServiceMatcher) {
        assert (aServiceMatcher != null);
        boolean hasMatchedService = false;
        for (ServiceDescriptor<S, SCTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            Object eService = theServiceDescriptor.getService();
            if (!aServiceMatcher.isMatching(eService)) continue;
            if (hasMatchedService) {
                return false;
            }
            hasMatchedService = true;
        }
        return hasMatchedService;
    }

    protected void registerLifecycleEventDispatcher(ObservableLifeCycleStatusAutomaton aObservableLifecycleAutomaton) {
        aObservableLifecycleAutomaton.subscribeObserver((Object)this._serviceBusObserver);
    }

    protected void onLifecycleEvent(LifeCycleRequestEvent aEvent) {
        switch (aEvent.getLifeCycleRequest()) {
            case INITIALIZE: {
                this.initializeServices();
                break;
            }
            case START: {
                this.startServices();
                break;
            }
            case PAUSE: {
                this.pauseServices();
                break;
            }
            case RESUME: {
                this.resumeServices();
                break;
            }
            case STOP: {
                this.stopServices();
                break;
            }
            case DESTROY: {
                this.destroyServices();
            }
        }
    }

    protected void initializeServices() {
        this.info("About to " + LifeCycleRequest.INITIALIZE + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isInitalizable()) continue;
            try {
                eServiceLifecycle.initialize();
            }
            catch (InitializeException e) {
                this.warn("Unable to \"" + LifeCycleRequest.INITIALIZE + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifeCycleStatus.INITIALIZED + "\".");
    }

    protected void startServices() {
        this.info("About to " + LifeCycleRequest.START + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isStartable()) continue;
            try {
                eServiceLifecycle.start();
            }
            catch (StartException e) {
                this.warn("Unable to \"" + LifeCycleRequest.START + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifeCycleStatus.STARTED + "\".");
    }

    protected void pauseServices() {
        this.info("About to " + LifeCycleRequest.PAUSE + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isPausable()) continue;
            try {
                eServiceLifecycle.pause();
            }
            catch (PauseException e) {
                this.warn("Unable to \"" + LifeCycleRequest.PAUSE + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifeCycleStatus.PAUSED + "\".");
    }

    protected void resumeServices() {
        this.info("About to " + LifeCycleRequest.RESUME + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isResumable()) continue;
            try {
                eServiceLifecycle.resume();
            }
            catch (ResumeException e) {
                this.warn("Unable to \"" + LifeCycleRequest.RESUME + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifeCycleStatus.STARTED + "\".");
    }

    protected void stopServices() {
        this.info("About to " + LifeCycleRequest.STOP + " services ...");
        for (ServiceDescriptor<S, SCTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!eServiceLifecycle.isStoppable()) continue;
            try {
                eServiceLifecycle.stop();
            }
            catch (StopException e) {
                this.warn("Unable to \"" + LifeCycleRequest.STOP + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifeCycleStatus.STOPPED + "\".");
    }

    protected void destroyServices() {
        this.info("About to " + LifeCycleRequest.DESTROY + " services ...");
        for (ServiceDescriptor<S, SCTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifeCycleStatusAutomaton theServiceLifecycle = ((ServiceContext)theServiceDescriptor.getServiceContext()).getObservableLifeCycleAutomaton();
            if (!theServiceLifecycle.isDestroyable()) continue;
            theServiceLifecycle.destroy();
        }
        this.info("Services \"" + LifeCycleStatus.DESTROYED + "\".");
    }

    private class ServiceBusObserver
    implements LifeCycleStatusObserver {
        private ServiceBusObserver() {
        }

        public void onInitialized(InitializedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onStarted(StartedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onResumed(ResumedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onPaused(PausedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onStopped(StoppedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onDestroyed(DestroyedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }
    }
}

