/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.servicebus;

import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleRequest;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.component.ext.observer.DestroyedEvent;
import org.refcodes.component.ext.observer.InitializedEvent;
import org.refcodes.component.ext.observer.LifecycleRequestEvent;
import org.refcodes.component.ext.observer.LifecycleStatusObserver;
import org.refcodes.component.ext.observer.ObservableLifecycleStatusAutomaton;
import org.refcodes.component.ext.observer.PausedEvent;
import org.refcodes.component.ext.observer.ResumedEvent;
import org.refcodes.component.ext.observer.StartedEvent;
import org.refcodes.component.ext.observer.StoppedEvent;
import org.refcodes.data.Text;
import org.refcodes.mixin.Loggable;
import org.refcodes.servicebus.AmbiguousServiceRuntimeException;
import org.refcodes.servicebus.NoMatchingServiceRuntimeException;
import org.refcodes.servicebus.Service;
import org.refcodes.servicebus.ServiceBus;
import org.refcodes.servicebus.ServiceContext;
import org.refcodes.servicebus.ServiceDescriptor;
import org.refcodes.servicebus.ServiceLookup;
import org.refcodes.servicebus.ServiceMatcher;

public class SimpleServiceBus<S extends Service<?>, CTX extends ServiceContext<S>>
implements ServiceBus<S>,
Loggable {
    private ServiceLookup<S, CTX> _serviceLookup;
    private ServiceBusObserver _serviceBusObserver = new ServiceBusObserver();

    public SimpleServiceBus(ServiceLookup<S, CTX> aServiceLookup, ObservableLifecycleStatusAutomaton aObservableLifecycleAutomaton) {
        assert (aServiceLookup != null);
        assert (aObservableLifecycleAutomaton != null);
        this._serviceLookup = aServiceLookup;
        this.registerLifecycleEventDispatcher(aObservableLifecycleAutomaton);
    }

    @Override
    public S lookupService(ServiceMatcher<S> aServiceMatcher) throws NoMatchingServiceRuntimeException, AmbiguousServiceRuntimeException {
        assert (aServiceMatcher != null);
        S theMatchedService = null;
        for (ServiceDescriptor<S, CTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            Object eService = theServiceDescriptor.getService();
            if (!aServiceMatcher.isMatching(eService)) continue;
            if (theMatchedService != null) {
                throw new AmbiguousServiceRuntimeException(aServiceMatcher, "The given service matcher matched more than one service.");
            }
            theMatchedService = eService;
        }
        if (theMatchedService == null) {
            throw new NoMatchingServiceRuntimeException(aServiceMatcher, "A service for the given matcher is not known by this service bus.");
        }
        return theMatchedService;
    }

    @Override
    public boolean hasService(ServiceMatcher<S> aServiceMatcher) {
        assert (aServiceMatcher != null);
        boolean hasMatchedService = false;
        for (ServiceDescriptor<S, CTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            Object eService = theServiceDescriptor.getService();
            if (!aServiceMatcher.isMatching(eService)) continue;
            if (hasMatchedService) {
                return false;
            }
            hasMatchedService = true;
        }
        return hasMatchedService;
    }

    protected void registerLifecycleEventDispatcher(ObservableLifecycleStatusAutomaton aObservableLifecycleAutomaton) {
        aObservableLifecycleAutomaton.subscribeObserver((Object)this._serviceBusObserver);
    }

    protected void onLifecycleEvent(LifecycleRequestEvent aEvent) {
        switch (aEvent.getLifecycleRequest()) {
            case INITIALIZE: {
                this.initializeServices();
                break;
            }
            case START: {
                this.startServices();
                break;
            }
            case PAUSE: {
                this.pauseServices();
                break;
            }
            case RESUME: {
                this.resumeServices();
                break;
            }
            case STOP: {
                this.stopServices();
                break;
            }
            case DESTROY: {
                this.destroyServices();
            }
        }
    }

    protected void initializeServices() {
        this.info("About to " + LifecycleRequest.INITIALIZE + " services ...");
        for (ServiceDescriptor<S, CTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifecycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifecycleAutomaton();
            if (!eServiceLifecycle.isInitalizable()) continue;
            try {
                eServiceLifecycle.initialize();
            }
            catch (InitializeException e) {
                this.warn("Unable to \"" + LifecycleRequest.INITIALIZE + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifecycleStatus.INITIALIZED + "\".");
    }

    protected void startServices() {
        this.info("About to " + LifecycleRequest.START + " services ...");
        for (ServiceDescriptor<S, CTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifecycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifecycleAutomaton();
            if (!eServiceLifecycle.isStartable()) continue;
            try {
                eServiceLifecycle.start();
            }
            catch (StartException e) {
                this.warn("Unable to \"" + LifecycleRequest.START + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifecycleStatus.STARTED + "\".");
    }

    protected void pauseServices() {
        this.info("About to " + LifecycleRequest.PAUSE + " services ...");
        for (ServiceDescriptor<S, CTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifecycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifecycleAutomaton();
            if (!eServiceLifecycle.isPausable()) continue;
            try {
                eServiceLifecycle.pause();
            }
            catch (PauseException e) {
                this.warn("Unable to \"" + LifecycleRequest.PAUSE + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifecycleStatus.PAUSED + "\".");
    }

    protected void resumeServices() {
        this.info("About to " + LifecycleRequest.RESUME + " services ...");
        for (ServiceDescriptor<S, CTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifecycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifecycleAutomaton();
            if (!eServiceLifecycle.isResumable()) continue;
            try {
                eServiceLifecycle.resume();
            }
            catch (ResumeException e) {
                this.warn("Unable to \"" + LifecycleRequest.RESUME + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifecycleStatus.STARTED + "\".");
    }

    protected void stopServices() {
        this.info("About to " + LifecycleRequest.STOP + " services ...");
        for (ServiceDescriptor<S, CTX> eServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifecycleStatusAutomaton eServiceLifecycle = ((ServiceContext)eServiceDescriptor.getServiceContext()).getObservableLifecycleAutomaton();
            if (!eServiceLifecycle.isStoppable()) continue;
            try {
                eServiceLifecycle.stop();
            }
            catch (StopException e) {
                this.warn("Unable to \"" + LifecycleRequest.STOP + "\" the service \"" + eServiceDescriptor.getClass().getName() + "\".", e);
            }
        }
        this.info("Services \"" + LifecycleStatus.STOPPED + "\".");
    }

    protected void destroyServices() {
        this.info("About to " + LifecycleRequest.DESTROY + " services ...");
        for (ServiceDescriptor<S, CTX> theServiceDescriptor : this._serviceLookup.getServiceDescriptors()) {
            ObservableLifecycleStatusAutomaton theServiceLifecycle = ((ServiceContext)theServiceDescriptor.getServiceContext()).getObservableLifecycleAutomaton();
            if (!theServiceLifecycle.isDestroyable()) continue;
            theServiceLifecycle.destroy();
        }
        this.info("Services \"" + LifecycleStatus.DESTROYED + "\".");
    }

    private class ServiceBusObserver
    implements LifecycleStatusObserver {
        private ServiceBusObserver() {
        }

        public void onInitialized(InitializedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onStarted(StartedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onResumed(ResumedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onPaused(PausedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onStopped(StoppedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }

        public void onDestroyed(DestroyedEvent aEvent) {
            throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
        }
    }
}

