package org.refcodes.servicebus;

import org.refcodes.servicebus.ServiceBusRuntimeException.ServiceBusServiceMatcherRuntimeException;

/**
 * This exception is thrown whenever a service cannot be unambiguously
 * distinguished from another service because a matcher was not strict enough to
 * identify just one service.
 */
public class AmbiguousServiceRuntimeException extends ServiceBusServiceMatcherRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aMessage The aMessage describing this exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String aMessage, String aErrorCode ) {
		super( aServiceMatcher, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aServiceMatcher, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String aMessage, Throwable aCause ) {
		super( aServiceMatcher, aMessage, aCause );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aMessage The aMessage describing this exception.
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String aMessage ) {
		super( aServiceMatcher, aMessage );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, Throwable aCause, String aErrorCode ) {
		super( aServiceMatcher, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, Throwable aCause ) {
		super( aServiceMatcher, aCause );
	}

}
