// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * Provides an accessor for a group TID property.
 */
public interface GroupIdAccessor {

	/**
	 * Retrieves the group TID from the group TID property.
	 * 
	 * @return The group TID stored by the group TID property.
	 */
	String getGroupId();

	/**
	 * Provides a mutator for a group TID property.
	 */
	public interface GroupIdMutator {

		/**
		 * Sets the group TID for the group TID property.
		 * 
		 * @param aGroupId The group TID to be stored by the group TID property.
		 */
		void setGroupId( String aGroupId );
	}

	/**
	 * Provides a group TID property.
	 */
	public interface GroupIdProperty extends GroupIdAccessor, GroupIdMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given {@link String} (setter)
		 * as of {@link #setGroupId(String)} and returns the very same value
		 * (getter).
		 * 
		 * @param aGroupId The {@link String} to set (via
		 *        {@link #setGroupId(String)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default String letGroupId( String aGroupId ) {
			setGroupId( aGroupId );
			return aGroupId;
		}
	}
}
