// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * Provides an accessor for a name TID property.
 */
public interface NameIdAccessor {

	/**
	 * Retrieves the name TID from the name TID property.
	 * 
	 * @return The name TID stored by the name TID property.
	 */
	String getNameId();

	/**
	 * Provides a mutator for a name TID property.
	 */
	public interface NameIdMutator {

		/**
		 * Sets the name TID for the name TID property.
		 * 
		 * @param aNameId The name TID to be stored by the name TID property.
		 */
		void setNameId( String aNameId );
	}

	/**
	 * Provides a name TID property.
	 */
	public interface NameIdProperty extends NameIdAccessor, NameIdMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given {@link String} (setter)
		 * as of {@link #setNameId(String)} and returns the very same value
		 * (getter).
		 * 
		 * @param aNameId The {@link String} to set (via
		 *        {@link #setNameId(String)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default String letNameId( String aNameId ) {
			setNameId( aNameId );
			return aNameId;
		}
	}
}
