// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * Provides an accessor for {@link Service}'s context property.
 *
 * @param <SCTX> The type to be used for the {@link Service}'s context.
 */
public interface ServiceContextAccessor<SCTX> {

	/**
	 * Retrieves the {@link Service}'s context property from the property.
	 * 
	 * @return Returns the {@link Service} property stored by the property.
	 */
	SCTX getServiceContext();

	/**
	 * Provides a mutator for {@link Service}'s context property.
	 *
	 * @param <SCTX> the generic type
	 */
	public interface ServiceContextMutator<SCTX> {

		/**
		 * Sets the {@link Service}'s context property for the property.
		 * 
		 * @param aServiceContext The {@link Service}'s context property to be
		 *        stored by the property.
		 */
		void setServiceContext( SCTX aServiceContext );
	}

	/**
	 * Provides a {@link Service}'s context property.
	 *
	 * @param <SCTX> the generic type
	 */
	public interface ServiceContextProperty<SCTX> extends ServiceContextAccessor<SCTX>, ServiceContextMutator<SCTX> {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given value (setter) as of
		 * {@link #setServiceContext(Object)} and returns the very same value
		 * (getter).
		 * 
		 * @param aServiceContext The value to set (via
		 *        {@link #setServiceContext(Object)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default SCTX letServiceContext( SCTX aServiceContext ) {
			setServiceContext( aServiceContext );
			return aServiceContext;
		}
	}
}
