// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import org.refcodes.component.ext.observer.ObservableLifecycleStatusAutomaton;

/**
 * The {@link ServiceContextImpl} implements the {@link ServiceContext}.
 *
 * @param <S> The type to be used for the {@link Service}.
 */
public class ServiceContextImpl<S extends Service<?>> implements ServiceContext<S> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private ObservableLifecycleStatusAutomaton _observableLifecycleAutomaton;

	private ServiceBus<S> _serviceBus;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs the {@link ServiceContextImpl} to be configured with the given
	 * {@link ObservableLifecycleStatusAutomaton}.
	 * 
	 * @param aServiceBus The {@link ServiceBus} with which to construct the
	 *        {@link ServiceContextImpl}.
	 * @param aObservableLifecycleAutomaton The
	 *        {@link ObservableLifecycleStatusAutomaton} with which to construct
	 *        the {@link ServiceContextImpl}.
	 */
	public ServiceContextImpl( ServiceBus<S> aServiceBus, ObservableLifecycleStatusAutomaton aObservableLifecycleAutomaton ) {
		_observableLifecycleAutomaton = aObservableLifecycleAutomaton;
		_serviceBus = aServiceBus;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ObservableLifecycleStatusAutomaton getObservableLifecycleAutomaton() {
		return _observableLifecycleAutomaton;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ServiceBus<S> getServiceBus() {
		return _serviceBus;
	}
}
