// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * Provides an accessor for a {@link ServiceDescriptor} property.
 *
 * @param <SD> the generic type
 */
public interface ServiceDescriptorAccessor<SD extends ServiceDescriptor<?, ?>> {

	/**
	 * Retrieves the {@link ServiceDescriptor} property from the property.
	 * 
	 * @return Returns the {@link ServiceDescriptor} property stored by the
	 *         property.
	 */
	SD getServiceDescriptor();

	/**
	 * Provides a mutator for a {@link ServiceDescriptor} property.
	 *
	 * @param <SD> the generic type
	 */
	public interface ServiceDescriptorMutator<SD extends ServiceDescriptor<?, ?>> {

		/**
		 * Sets the {@link Service} property from the property.
		 *
		 * @param aServiceDescriptor the new service descriptor
		 */
		void setServiceDescriptor( SD aServiceDescriptor );
	}

	/**
	 * Provides a {@link ServiceDescriptor} property.
	 *
	 * @param <SD> the generic type
	 */
	public interface ServiceDescriptorProperty<SD extends ServiceDescriptor<?, ?>> extends ServiceDescriptorAccessor<SD>, ServiceDescriptorMutator<SD> {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given value (setter) as of
		 * {@link #setServiceDescriptor(ServiceDescriptor)} and returns the very
		 * same value (getter).
		 * 
		 * @param aServiceDescriptor The value to set (via
		 *        {@link #setServiceDescriptor(ServiceDescriptor)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default SD letServiceDescriptor( SD aServiceDescriptor ) {
			setServiceDescriptor( aServiceDescriptor );
			return aServiceDescriptor;
		}
	}
}
