// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * The {@link ServiceDescriptorImpl} implements the {@link ServiceDescriptor}.
 *
 * @param <S> The type to be used for the {@link Service}.
 * @param <SCTX> The type to be used for the {@link Service}'s context.
 */
public class ServiceDescriptorImpl<S extends Service<?>, SCTX> implements ServiceDescriptor<S, SCTX> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private S _service;

	private SCTX _serviceContext;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs the {@link ServiceDescriptorImpl} to be configured with the
	 * given {@link Service} and the given context.
	 * 
	 * @param aService The {@link Service} with which to configure the
	 *        {@link ServiceDirectoryImpl}.
	 * @param aServiceContext The {@link Service}'s context with which to
	 *        configure the {@link ServiceDirectoryImpl}.
	 */
	public ServiceDescriptorImpl( S aService, SCTX aServiceContext ) {
		_service = aService;
		_serviceContext = aServiceContext;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public SCTX getServiceContext() {
		return _serviceContext;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public S getService() {
		return _service;
	}

}
