// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * The service descriptor manager can be used to manage services and them
 * configurations, i.e a system administering services in an my have access to a
 * service descriptor manager.
 *
 * @param <S> The type to be used for the {@link Service}.
 * @param <SCTX> The type to be used for the {@link Service}'s context.
 */
public interface ServiceDirectory<S extends Service<?>, SCTX> extends ServiceLookup<S, SCTX> {

	/**
	 * Registers a service to the service bus.
	 *
	 * @param aServiceDescriptor the service descriptor
	 * 
	 * @throws DuplicateServiceRuntimeException in case the service cannot be
	 *         identified unambiguously by a matcher. A matcher declaration must
	 *         be possible to identify the given service unambiguously. The
	 *         service as being described by the service type and the service
	 *         Meta-Data is already registered to the service bus.
	 */
	void addService( ServiceDescriptor<S, SCTX> aServiceDescriptor ) throws DuplicateServiceRuntimeException;

	/**
	 * Unregisters a service to the service bus.
	 *
	 * @param aServiceDescriptor the service descriptor
	 * 
	 * @throws UnknownServiceRuntimeException in case the service is not known.
	 */
	void removeService( ServiceDescriptor<S, SCTX> aServiceDescriptor ) throws UnknownServiceRuntimeException;
}
