// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import java.util.Set;

/**
 * The interface may be used internally by a system managing services. Having
 * access to an object providing this interface such a system can "work" with
 * the services and them configurations.
 *
 * @param <S> The type to be used for the {@link Service}.
 * @param <SCTX> The type to be used for the {@link Service}'s context.
 */
public interface ServiceLookup<S extends Service<?>, SCTX> {

	/**
	 * Returns a collection containing the {@link ServiceDescriptor} instances
	 * known by the {@link ServiceLookup}.
	 * 
	 * @return A collection containing the {@link ServiceDescriptor} instances
	 *         known by the {@link ServiceLookup}.
	 */
	public Set<ServiceDescriptor<S, SCTX>> getServiceDescriptors();

	/**
	 * Determines whether the given service is known by the service bus by
	 * taking the service type and the service Meta-Data as criteria, not the
	 * service identity. I.e. there must not be the same service twice on the
	 * service bus which can not be distinguished by its type and its Meta-Data
	 * (i.e. a matcher must be able to distinguish two services from each
	 * other).
	 *
	 * @param aServiceDescriptor the service descriptor
	 * 
	 * @return True in case the given service is known by the service bus.
	 */
	boolean hasService( ServiceDescriptor<S, SCTX> aServiceDescriptor );
}
