// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * Provides an accessor for a {@link ServiceMatcher} property.
 */
public interface ServiceMatcherAccessor {

	/**
	 * Retrieves the {@link ServiceMatcher} property from the property.
	 * 
	 * @return Returns the {@link ServiceMatcher} property stored by the
	 *         property.
	 */
	ServiceMatcher<?> getServiceMatcher();

	/**
	 * Provides a mutator for a {@link ServiceMatcher} property.
	 */
	public interface ServiceMatcherMutator {

		/**
		 * Sets the {@link ServiceMatcher} property for the property.
		 * 
		 * @param aServiceMatcher The {@link ServiceMatcher} property to be
		 *        stored by the property.
		 */
		void setServiceMatcher( ServiceMatcher<?> aServiceMatcher );
	}

	/**
	 * Provides a {@link ServiceMatcher} property.
	 */
	public interface ServiceMatcherProperty extends ServiceMatcherAccessor, ServiceMatcherMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given {@link ServiceMatcher}
		 * (setter) as of {@link #setServiceMatcher(ServiceMatcher)} and returns
		 * the very same value (getter).
		 * 
		 * @param aServiceMatcher The {@link ServiceMatcher} to set (via
		 *        {@link #setServiceMatcher(ServiceMatcher)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default ServiceMatcher<?> letServiceMatcher( ServiceMatcher<?> aServiceMatcher ) {
			setServiceMatcher( aServiceMatcher );
			return aServiceMatcher;
		}
	}
}
