// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.UniversalIdAccessor;

/**
 * Service Meta-Data describes criteria identifying a specific service within a
 * pool of services. This is necessary when using a service bus and when we
 * might have some services of the same type but with different configurations
 * or other properties. In order to encapsulate the data for identifying and
 * loosely coupling services, the Meta-Data describing the service is placed in
 * an Meta-Data object. The Meta-Data is not placed in the service itself
 * (attribute by attribute) to avoid unclear service interfaces (with lots of
 * Meta-Data mixing with the service's functionality) as the main purpose of a
 * service is not providing Meta-Data.
 */
public interface ServiceMetaData extends UniversalIdAccessor, GroupIdAccessor, NameIdAccessor, NameAccessor {}
