// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * The {@link ServiceMetaDataImpl} implements the {@link ServiceMetaData}.
 */
public class ServiceMetaDataImpl implements ServiceMetaData {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _universalId;

	private String _nameId;

	private String _groupId;

	private String _name;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a {@link ServiceMetaDataImpl} with the given attributes.
	 * 
	 * @param aUid The UID to be used.
	 * @param aNameId The name TID to be used.
	 * @param aGroupId The group TID to be used.
	 * @param aName The (verbose) name to be used.
	 */
	public ServiceMetaDataImpl( String aUid, String aNameId, String aGroupId, String aName ) {
		_universalId = aUid;
		_nameId = aNameId;
		_groupId = aGroupId;
		_name = aName;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getUniversalId() {
		return _universalId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getGroupId() {
		return _groupId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getNameId() {
		return _nameId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return _name;
	}
}