// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import org.refcodes.servicebus.ServiceBusRuntimeException.ServiceBusServiceRuntimeException;

/**
 * This exception is thrown whenever a service, which cannot be distinguished
 * from another service, is added to the service bus. In such a case, no matcher
 * would be able to match exactly one of them services, we would end up with a
 * non deterministic system.
 */
public class UnknownServiceRuntimeException extends ServiceBusServiceRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new unknown service runtime exception.
	 *
	 * @param aService the service
	 * @param aMessage The aMessage describing this exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public UnknownServiceRuntimeException( Service<?> aService, String aMessage, String aErrorCode ) {
		super( aService, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new unknown service runtime exception.
	 *
	 * @param aService the service
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public UnknownServiceRuntimeException( Service<?> aService, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aService, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new unknown service runtime exception.
	 *
	 * @param aService the service
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public UnknownServiceRuntimeException( Service<?> aService, String aMessage, Throwable aCause ) {
		super( aService, aMessage, aCause );
	}

	/**
	 * Instantiates a new unknown service runtime exception.
	 *
	 * @param aService the service
	 * @param aMessage The aMessage describing this exception.
	 */
	public UnknownServiceRuntimeException( Service<?> aService, String aMessage ) {
		super( aService, aMessage );
	}

	/**
	 * Instantiates a new unknown service runtime exception.
	 *
	 * @param aService the service
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public UnknownServiceRuntimeException( Service<?> aService, Throwable aCause, String aErrorCode ) {
		super( aService, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new unknown service runtime exception.
	 *
	 * @param aService the service
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public UnknownServiceRuntimeException( Service<?> aService, Throwable aCause ) {
		super( aService, aCause );
	}

}
