/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.ext.factory.CanonicalMapFactory;

public abstract class AbstractCanonicalMapFactory
implements CanonicalMapFactory {
    static final String INDEX_ATTRIBUTE = "index";
    static final String[] THIS_ATTRIBUTES = new String[]{"this", ".", "_"};

    protected void postProcess(CanonicalMap.CanonicalMapBuilder aProperties) {
        HashSet theKeys = new HashSet(aProperties.keySet());
        for (String ePrefix : new String[]{"", "" + aProperties.getAnnotator()}) {
            for (String eAttribute : THIS_ATTRIBUTES) {
                String theAttributeSuffix = aProperties.getDelimiter() + ePrefix + eAttribute;
                for (String eKey : theKeys) {
                    String ePropertyKey;
                    String ePropertyValue;
                    String eValue;
                    if (!eKey.endsWith(theAttributeSuffix) || (eValue = (String)aProperties.get((Object)eKey)) == null || eValue.length() == 0 || (ePropertyValue = (String)aProperties.get((Object)(ePropertyKey = eKey.substring(0, eKey.length() - theAttributeSuffix.length())))) != null && ePropertyValue.length() != 0) continue;
                    aProperties.put((Object)ePropertyKey, (Object)eValue);
                    aProperties.remove((Object)eKey);
                }
            }
        }
    }

    protected String toString(InputStream aInputStream) throws IOException {
        int eRead;
        ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
        byte[] theData = new byte[16384];
        while ((eRead = aInputStream.read(theData, 0, theData.length)) != -1) {
            theBuffer.write(theData, 0, eRead);
        }
        theBuffer.flush();
        return theBuffer.toString();
    }

    protected InputStream toInputStream(String aString) {
        return new ByteArrayInputStream(aString.getBytes(StandardCharsets.UTF_8));
    }

    protected char toDelimiter(Map<String, String> aProperties, char aDefaultDelimiter) {
        String theDelimiterString;
        char theDelimiter = aDefaultDelimiter;
        if (aProperties != null && (theDelimiterString = aProperties.get(DELIMITER_PROPERTY)) != null && theDelimiterString.length() != 0) {
            theDelimiter = theDelimiterString.charAt(0);
        }
        return theDelimiter;
    }

    protected char[] toSupportedDelimiters(Map<String, String> aProperties) {
        String theDelimiterString;
        char[] theDelimiters = null;
        if (aProperties != null && (theDelimiterString = aProperties.get(SUPPORTED_DELIMITERS_PROPERTY)) != null && theDelimiterString.length() != 0) {
            theDelimiters = theDelimiterString.toCharArray();
        }
        if (theDelimiters == null) {
            theDelimiters = new char[]{CanonicalMap.DELIMITER};
        }
        return theDelimiters;
    }

    protected String toComment(Map<String, String> aProperties) {
        String theComment = null;
        if (aProperties != null && aProperties.containsKey(COMMENT_PROPERTY)) {
            theComment = aProperties.get(COMMENT_PROPERTY);
        }
        return theComment;
    }

    protected static String toXml(CanonicalMap aCanonicalMap) {
        return AbstractCanonicalMapFactory.toXml(aCanonicalMap, aCanonicalMap.getRootPath(), "");
    }

    private static String toXml(CanonicalMap aCanonicalMap, String aPath, String aIndent) {
        StringBuilder theBuffer = new StringBuilder();
        for (String eChild : aCanonicalMap.children(aPath)) {
            String theArray;
            String ePath = aCanonicalMap.toPath(new String[]{aPath, eChild});
            if (aCanonicalMap.isArray(ePath)) {
                theArray = AbstractCanonicalMapFactory.toArrayIndex(aCanonicalMap, aPath, eChild, aIndent);
                theBuffer.append(theArray);
                continue;
            }
            if (aCanonicalMap.isIndexDir(ePath)) {
                theArray = AbstractCanonicalMapFactory.toDirIndex(aCanonicalMap, aPath, eChild, aIndent);
                theBuffer.append(theArray);
                continue;
            }
            if (eChild.startsWith("" + aCanonicalMap.getAnnotator())) continue;
            String theAttributes = AbstractCanonicalMapFactory.toAttributes(aCanonicalMap, ePath);
            String eElement = AbstractCanonicalMapFactory.toElement(aCanonicalMap, aPath, eChild, aIndent, theAttributes);
            theBuffer.append(eElement);
        }
        return theBuffer.toString();
    }

    private static String toElement(CanonicalMap aCanonicalMap, String aPath, String aChild, String aIndent, String aAttribs) {
        String theContent;
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aCanonicalMap.toPath(new String[]{aPath, aChild});
        theBuffer.append(aIndent);
        theBuffer.append("<" + aChild + aAttribs);
        String theValue = "";
        if (aCanonicalMap.containsKey((Object)thePath)) {
            theValue = (String)aCanonicalMap.get((Object)thePath);
        }
        if (!((theContent = AbstractCanonicalMapFactory.toXml(aCanonicalMap, thePath, aIndent + "\t")) != null && theContent.length() != 0 || theValue != null && theValue.length() != 0)) {
            theBuffer.append("/>");
        } else {
            theBuffer.append(">");
            theBuffer.append(theValue);
            if (theContent.length() != 0) {
                theBuffer.append(System.lineSeparator());
                theBuffer.append(theContent);
                theBuffer.append(aIndent);
            }
            theBuffer.append("</" + aChild + ">");
            theBuffer.append(System.lineSeparator());
        }
        return theBuffer.toString();
    }

    private static String toAttributes(CanonicalMap aCanonicalMap, String aPath) {
        StringBuilder theBuffer = new StringBuilder();
        Set theAttribPaths = aCanonicalMap.queryPaths(new String[]{aPath, PathMap.ANNOTATOR + "*"});
        for (String ePath : theAttribPaths) {
            String eValue = (String)aCanonicalMap.get((Object)ePath);
            String eLeaf = aCanonicalMap.toLeaf(ePath).substring(1);
            if (theBuffer.length() != 0) {
                theBuffer.append(" ");
            }
            theBuffer.append(eLeaf);
            theBuffer.append('=');
            theBuffer.append('\"');
            theBuffer.append(eValue);
            theBuffer.append('\"');
        }
        if (theBuffer.length() != 0) {
            theBuffer.insert(0, ' ');
        }
        return theBuffer.toString();
    }

    private static String toArrayIndex(CanonicalMap aCanonicalMap, String aPath, String aChild, String aIndent) {
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aCanonicalMap.toPath(new String[]{aPath, aChild});
        int[] indexes = aCanonicalMap.getArrayIndexes(thePath);
        String theAttribs = AbstractCanonicalMapFactory.toAttributes(aCanonicalMap, thePath);
        for (int i : indexes) {
            String eIndex = AbstractCanonicalMapFactory.toArrayIndex(aCanonicalMap, thePath, i, aChild, theAttribs, aIndent);
            theBuffer.append(eIndex);
        }
        return theBuffer.toString();
    }

    private static String toArrayIndex(CanonicalMap aCanonicalMap, String aPath, int aIndex, String aElement, String aAttribs, String aIndent) {
        String theAttribs = AbstractCanonicalMapFactory.toAttributes(aCanonicalMap, aCanonicalMap.toPath(new Object[]{aPath, aIndex}));
        aAttribs = (String)aAttribs + theAttribs;
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(aIndent);
        theBuffer.append("<");
        theBuffer.append(aElement);
        theBuffer.append((String)aAttribs);
        theBuffer.append(" index=\"");
        theBuffer.append(aIndex);
        theBuffer.append("\"");
        String theValue = (String)aCanonicalMap.get(new Object[]{aPath, aIndex});
        if (theValue == null || theValue.length() == 0) {
            theBuffer.append("/>");
        } else {
            theBuffer.append('>');
            theBuffer.append(theValue);
            theBuffer.append("</");
            theBuffer.append(aElement);
            theBuffer.append('>');
        }
        theBuffer.append(System.lineSeparator());
        return theBuffer.toString();
    }

    private static String toDirIndex(CanonicalMap aCanonicalMap, String aPath, String aChild, String aIndent) {
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aCanonicalMap.toPath(new String[]{aPath, aChild});
        int[] indexes = aCanonicalMap.getDirIndexes(thePath);
        String theAttribs = AbstractCanonicalMapFactory.toAttributes(aCanonicalMap, thePath);
        for (int i : indexes) {
            CanonicalMap eCanonicalMap = aCanonicalMap.getDirAt(thePath, i);
            String eIndex = AbstractCanonicalMapFactory.toDirIndex(eCanonicalMap, thePath, i, aChild, theAttribs, aIndent);
            theBuffer.append(eIndex);
        }
        return theBuffer.toString();
    }

    private static String toDirIndex(CanonicalMap aCanonicalMap, String aPath, int aIndex, String aElement, String aAttribs, String aIndent) {
        StringBuilder theBuffer = new StringBuilder();
        String theAttribs = AbstractCanonicalMapFactory.toAttributes(aCanonicalMap, aCanonicalMap.getRootPath());
        theBuffer.append(aIndent);
        theBuffer.append("<");
        theBuffer.append(aElement);
        theBuffer.append(aAttribs);
        theBuffer.append(theAttribs + " index=\"");
        theBuffer.append(aIndex);
        theBuffer.append("\"");
        String theValue = AbstractCanonicalMapFactory.toXml(aCanonicalMap, "", aIndent + "\t");
        if (theValue == null || theValue.length() == 0) {
            theBuffer.append("/>");
        } else {
            theBuffer.append('>');
            theBuffer.append(System.lineSeparator());
            theBuffer.append(theValue);
            theBuffer.append(System.lineSeparator());
            theBuffer.append(aIndent);
            theBuffer.append("</");
            theBuffer.append(aElement);
            theBuffer.append('>');
        }
        theBuffer.append(System.lineSeparator());
        return theBuffer.toString();
    }
}

