/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.CanonicalMapImpl;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactoryTest;
import org.refcodes.struct.ext.factory.HtmlCanonicalMapFactory;

public class HtmlCanonicalMapFactoryTest
extends AbstractCanonicalMapFactoryTest {
    @Test
    public void tesMarshalUnmarshal() throws MarshalException, UnmarshalException {
        HtmlCanonicalMapFactory theFactory = new HtmlCanonicalMapFactory();
        CanonicalMapBuilderImpl theDataStructure = new CanonicalMapBuilderImpl();
        theDataStructure.put((Object)"html/body/aaa/aaa_111", (Object)"aaa_111");
        theDataStructure.put((Object)"html/body/aaa/aaa_222", (Object)"aaa_222");
        theDataStructure.put((Object)"html/body/aaa/aaa_333", (Object)"aaa_333");
        theDataStructure.put((Object)"html/body/bbb/bbb_111", (Object)"bbb_111");
        theDataStructure.put((Object)"html/body/bbb/bbb_222", (Object)"bbb_222");
        theDataStructure.put((Object)"html/body/bbb/bbb_333", (Object)"bbb_333");
        theDataStructure.put((Object)"html/body/ccc/ccc_111", (Object)"ccc_111");
        theDataStructure.put((Object)"html/body/ccc/ccc_222", (Object)"ccc_222");
        theDataStructure.put((Object)"html/body/ccc/ccc_333", (Object)"ccc_333");
        HashMap<String, String> theProperties = new HashMap<String, String>();
        theProperties.put("comment", "Hello world, this is a comment!");
        String theMarshaled = theFactory.toMarshaled((CanonicalMap)theDataStructure, theProperties);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theMarshaled);
        }
        CanonicalMap.CanonicalMapBuilder theUnmarshaled = theFactory.toUnmarshaled(theMarshaled);
        theUnmarshaled.remove("html", "head");
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theFactory.toMarshaled((CanonicalMap)theUnmarshaled));
        }
        Assertions.assertEquals((int)theDataStructure.size(), (int)theUnmarshaled.size());
        for (String eKey : theDataStructure.sortedKeys()) {
            Assertions.assertEquals((Object)theDataStructure.get((Object)eKey), (Object)theUnmarshaled.get((Object)eKey));
        }
    }

    @Test
    public void testObjectGraph() throws MarshalException, UnmarshalException {
        HtmlCanonicalMapFactory theFactory = new HtmlCanonicalMapFactory();
        AbstractCanonicalMapFactoryTest.Person thePerson = new AbstractCanonicalMapFactoryTest.Person("Nolan", "Bushnell");
        AbstractCanonicalMapFactoryTest.Person theChild = new AbstractCanonicalMapFactoryTest.Person("Atari", "VCS 2600");
        thePerson.setChild(theChild);
        AbstractCanonicalMapFactoryTest.Car theCar = new AbstractCanonicalMapFactoryTest.Car("Trabant", "Turbo 2000");
        thePerson.setCar(theCar);
        CanonicalMapImpl theDataStructure = new CanonicalMapImpl((Object)thePerson);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theDataStructure.sortedKeys()) {
                System.out.println(eKey + ": " + (String)theDataStructure.get((Object)eKey));
            }
        }
        String theBody = theFactory.toMarshaled((CanonicalMap)theDataStructure);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(theBody);
            }
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("================================================================================");
            }
        }
    }
}

