/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.CanonicalMapImpl;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactoryTest;
import org.refcodes.struct.ext.factory.HtmlCanonicalMapFactorySingleton;
import org.refcodes.struct.ext.factory.XmlCanonicalMapFactory;

public class XmlCanonicalMapFactoryTest {
    @Test
    public void tesMarshalUnmarshal() throws MarshalException, UnmarshalException {
        XmlCanonicalMapFactory theFactory = new XmlCanonicalMapFactory();
        CanonicalMapBuilderImpl theDataStructure = new CanonicalMapBuilderImpl();
        theDataStructure.put((Object)"root/aaa/aaa_111", (Object)"aaa_111");
        theDataStructure.put((Object)"root/aaa/aaa_222", (Object)"aaa_222");
        theDataStructure.put((Object)"root/aaa/aaa_333", (Object)"aaa_333");
        theDataStructure.put((Object)"root/bbb/bbb_111", (Object)"bbb_111");
        theDataStructure.put((Object)"root/bbb/bbb_222", (Object)"bbb_222");
        theDataStructure.put((Object)"root/bbb/bbb_333", (Object)"bbb_333");
        theDataStructure.put((Object)"root/ccc/ccc_111", (Object)"ccc_111");
        theDataStructure.put((Object)"root/ccc/ccc_222", (Object)"ccc_222");
        theDataStructure.put((Object)"root/ccc/ccc_333", (Object)"ccc_333");
        HashMap<String, String> theProperties = new HashMap<String, String>();
        theProperties.put("comment", "Hello world, this is a comment!");
        String theMarshaled = theFactory.toMarshaled((CanonicalMap)theDataStructure, theProperties);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theMarshaled);
        }
        CanonicalMap.CanonicalMapBuilder theUnmarshaled = theFactory.toUnmarshaled(theMarshaled);
        Assertions.assertEquals((int)theDataStructure.size(), (int)theUnmarshaled.size());
        for (String eKey : theDataStructure.sortedKeys()) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(eKey + "=" + (String)theUnmarshaled.get((Object)eKey));
            }
            Assertions.assertEquals((Object)theDataStructure.get((Object)eKey), (Object)theUnmarshaled.get((Object)eKey));
        }
    }

    @Disabled(value="For debugging purposes only")
    @Test
    public void testToXml() throws UnmarshalException {
        CanonicalMapBuilderImpl theDataStructure = new CanonicalMapBuilderImpl();
        theDataStructure.put((Object)"html/body/aaa/bbb/@attr1", (Object)"1");
        theDataStructure.put((Object)"html/body/aaa/bbb/@attr2", (Object)"2");
        theDataStructure.put((Object)"html/body/aaa/bbb/@attr3", (Object)"3");
        theDataStructure.put((Object)"html/body/aaa/bbb", (Object)"BBB");
        theDataStructure.put((Object)"html/body/aaa/@attr1", (Object)"1");
        theDataStructure.put((Object)"html/body/aaa/@attr2", (Object)"2");
        theDataStructure.put((Object)"html/body/aaa/@attr3", (Object)"3");
        theDataStructure.put((Object)"html/body/aaa/bbb/ccc/@attr1", (Object)"1");
        theDataStructure.put((Object)"html/body/aaa/bbb/ccc/@attr2", (Object)"2");
        theDataStructure.put((Object)"html/body/aaa/bbb/ccc/@attr3", (Object)"3");
        theDataStructure.put((Object)"html/body/aaa/bbb/ccc/ddd", (Object)"DDD");
        theDataStructure.put((Object)"html/body/aaa/xxx", (Object)"BBB");
        String theXml = XmlCanonicalMapFactory.toXml((CanonicalMap)theDataStructure);
        System.out.println(theXml);
        CanonicalMap.CanonicalMapBuilder theBuilder = HtmlCanonicalMapFactorySingleton.getInstance().toUnmarshaled(theXml);
        for (String eKey : theBuilder.sortedKeys()) {
            System.out.println(eKey + " = " + (String)theBuilder.get((Object)eKey));
        }
    }

    @Test
    public void testObjectGraph() throws MarshalException, UnmarshalException {
        XmlCanonicalMapFactory theFactory = new XmlCanonicalMapFactory();
        AbstractCanonicalMapFactoryTest.Person thePerson = new AbstractCanonicalMapFactoryTest.Person("Nolan", "Bushnell");
        AbstractCanonicalMapFactoryTest.Person theChild = new AbstractCanonicalMapFactoryTest.Person("Atari", "VCS 2600");
        thePerson.setChild(theChild);
        AbstractCanonicalMapFactoryTest.Car theCar = new AbstractCanonicalMapFactoryTest.Car("Trabant", "Turbo 2000");
        thePerson.setCar(theCar);
        CanonicalMapImpl theDataStructure = new CanonicalMapImpl((Object)thePerson);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theDataStructure.sortedKeys()) {
                System.out.println(eKey + ": " + (String)theDataStructure.get((Object)eKey));
            }
        }
        String theBody = theFactory.toMarshaled((CanonicalMap)theDataStructure);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(theBody);
            }
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("================================================================================");
            }
        }
    }

    @Test
    public void tesIndexed() throws MarshalException, UnmarshalException {
        XmlCanonicalMapFactory theFactory = new XmlCanonicalMapFactory();
        CanonicalMapBuilderImpl theDataStructure = new CanonicalMapBuilderImpl();
        theDataStructure.put((Object)"root/x/1/aaa_111", (Object)"aaa_111");
        theDataStructure.put((Object)"root/x/1/aaa_222", (Object)"aaa_222");
        theDataStructure.put((Object)"root/x/1/aaa_333", (Object)"aaa_333");
        theDataStructure.put((Object)"root/x/1/aaa_444/0", (Object)"X");
        theDataStructure.put((Object)"root/x/1/aaa_444/1", (Object)"A");
        theDataStructure.put((Object)"root/x/1/aaa_444/2", (Object)"B");
        theDataStructure.put((Object)"root/x/1/aaa_444/3", (Object)"C");
        theDataStructure.put((Object)"root/x/2/bbb_111", (Object)"bbb_111");
        theDataStructure.put((Object)"root/x/2/bbb_222", (Object)"bbb_222");
        theDataStructure.put((Object)"root/x/2/bbb_333", (Object)"bbb_333");
        theDataStructure.put((Object)"root/x/2/bbb_444/0", (Object)"X");
        theDataStructure.put((Object)"root/x/2/bbb_444/1", (Object)"A");
        theDataStructure.put((Object)"root/x/2/bbb_444/2", (Object)"B");
        theDataStructure.put((Object)"root/x/2/bbb_444/3", (Object)"C");
        theDataStructure.put((Object)"root/x/3/ccc_111", (Object)"ccc_111");
        theDataStructure.put((Object)"root/x/3/ccc_222", (Object)"ccc_222");
        theDataStructure.put((Object)"root/x/3/ccc_333", (Object)"ccc_333");
        theDataStructure.put((Object)"root/x/3/ccc_444/0", (Object)"X");
        theDataStructure.put((Object)"root/x/3/ccc_444/1", (Object)"A");
        theDataStructure.put((Object)"root/x/3/ccc_444/2", (Object)"B");
        theDataStructure.put((Object)"root/x/3/ccc_444/3", (Object)"C");
        theDataStructure.put((Object)"root/x/@attrib", (Object)"ATTRIB");
        theDataStructure.put((Object)"root/x/1/aaa_444/@xyz", (Object)"XYZ");
        theDataStructure.put((Object)"root/x/2/bbb_444/@xyz", (Object)"XYZ");
        theDataStructure.put((Object)"root/x/3/ccc_444/@xyz", (Object)"XYZ");
        HashMap<String, String> theProperties = new HashMap<String, String>();
        theProperties.put("comment", "Hello world, this is a comment!");
        String theMarshaled = theFactory.toMarshaled((CanonicalMap)theDataStructure, theProperties);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theMarshaled);
        }
        CanonicalMap.CanonicalMapBuilder theUnmarshaled = theFactory.toUnmarshaled(theMarshaled);
        for (String eKey : theUnmarshaled.sortedKeys()) {
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println(eKey + "=" + (String)theUnmarshaled.get((Object)eKey));
        }
        String theXml = theFactory.toMarshaled((CanonicalMap)theUnmarshaled, theProperties);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theXml);
        }
        Object[] theMarshaledArray = theMarshaled.split("\n");
        Object[] theXmlArray = theXml.split("\n");
        Arrays.sort(theMarshaledArray);
        Arrays.sort(theXmlArray);
        Assertions.assertArrayEquals((Object[])theMarshaledArray, (Object[])theXmlArray);
    }

    @Test
    public void tesEdgeCase() throws MarshalException, UnmarshalException, IOException {
        XmlCanonicalMapFactory theFactory = new XmlCanonicalMapFactory();
        CanonicalMap.CanonicalMapBuilder theBuilder = theFactory.fromMarshaled(this.getClass().getResourceAsStream("/test.xml"));
        try (BufferedReader theReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/test.txt")));){
            for (String eKey : theBuilder.sortedKeys()) {
                String theResult = eKey + "=" + (String)theBuilder.get((Object)eKey);
                if (SystemProperty.LOG_TESTS.isEnabled()) {
                    System.out.println(theResult);
                }
                String theLine = theReader.readLine();
                Assertions.assertEquals((Object)theLine, (Object)theResult);
            }
        }
    }
}

