/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.structure;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.refcodes.data.Delimiter;
import org.refcodes.structure.Keys;
import org.refcodes.structure.PathMap;
import org.refcodes.structure.PathMapImpl;
import org.refcodes.structure.TypeUtility;

public class PathMapBuilderImpl<T>
extends HashMap<String, T>
implements PathMap.PathMapBuilder<T> {
    private static final long serialVersionUID = 1L;
    private boolean IS_DEBUG_OUTPUT = false;
    private static final String ESCAPE = "\\";
    private static final String SPECIAL_REGEX_CHARS = ".^$*+?()[{\\|";
    private static String[] BLACKLISTED_PROPERTIES = new String[]{"class"};
    private char _delimiter;
    private Class<T> _type;

    public PathMapBuilderImpl(Class<T> aType) {
        this(Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(char aDelimiter, Class<T> aType) {
        this._delimiter = aDelimiter;
        this._type = aType;
    }

    public PathMapBuilderImpl(Object aObj, Class<T> aType) {
        this(aObj, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, Class<T> aType) {
        this(aToPath, aObj, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(Object aObj, String aFromPath, Class<T> aType) {
        this(aObj, aFromPath, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, String aFromPath, Class<T> aType) {
        this(aToPath, aObj, aFromPath, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(Object aObj, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        super.fromValue(this.getRootPath(), aObj, new HashSet<Object>());
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        this.insertTo(aToPath, aObj);
    }

    public PathMapBuilderImpl(Object aObj, String aFromPath, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        this.insertFrom(aObj, aFromPath);
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, String aFromPath, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        this.insert(aToPath, aObj, aFromPath);
    }

    @Override
    public boolean containsKey(Object aPath) {
        return super.containsKey(this.toNormalizedPath(aPath != null ? aPath.toString() : null));
    }

    @Override
    public T get(Object aPath) {
        return (T)super.get(this.toNormalizedPath(aPath != null ? aPath.toString() : null));
    }

    @Override
    public T put(String aPath, T value) {
        return super.put(this.toNormalizedPath(aPath), value);
    }

    @Override
    public T remove(Object aPath) {
        return (T)super.remove(this.toNormalizedPath(aPath != null ? aPath.toString() : null));
    }

    @Override
    public T getOrDefault(Object aPath, T publicValue) {
        return super.getOrDefault(this.toNormalizedPath(aPath != null ? aPath.toString() : null), publicValue);
    }

    @Override
    public T putIfAbsent(String aPath, T value) {
        return super.putIfAbsent(this.toNormalizedPath(aPath), value);
    }

    @Override
    public boolean remove(Object aPath, Object value) {
        return super.remove(this.toNormalizedPath(aPath != null ? aPath.toString() : null), value);
    }

    @Override
    public boolean replace(String aPath, T oldValue, T newValue) {
        return super.replace(this.toNormalizedPath(aPath), oldValue, newValue);
    }

    @Override
    public T replace(String aPath, T value) {
        return super.replace(this.toNormalizedPath(aPath), value);
    }

    @Override
    public T computeIfAbsent(String aPath, Function<? super String, ? extends T> mappingFunction) {
        return super.computeIfAbsent(this.toNormalizedPath(aPath), mappingFunction);
    }

    @Override
    public T computeIfPresent(String aPath, BiFunction<? super String, ? super T, ? extends T> remappingFunction) {
        return super.computeIfPresent(this.toNormalizedPath(aPath), remappingFunction);
    }

    @Override
    public T compute(String aPath, BiFunction<? super String, ? super T, ? extends T> remappingFunction) {
        return super.compute(this.toNormalizedPath(aPath), remappingFunction);
    }

    @Override
    public T merge(String aPath, T value, BiFunction<? super T, ? super T, ? extends T> remappingFunction) {
        return super.merge(this.toNormalizedPath(aPath), value, remappingFunction);
    }

    @Override
    public PathMap<T> retrieveTo(String aToPath) {
        PathMapBuilderImpl<T> theToPathMap = new PathMapBuilderImpl<T>(this.getDelimiter(), this._type);
        PathMapImpl.retrieveTo(this, aToPath, theToPathMap);
        return theToPathMap;
    }

    @Override
    public PathMap<T> childrenOf(String aParentPath) {
        PathMapBuilderImpl<T> theToPathMap = new PathMapBuilderImpl<T>(this.getDelimiter(), this._type);
        PathMapImpl.childrenOf(this, aParentPath, theToPathMap);
        return theToPathMap;
    }

    @Override
    public PathMap<T> retrieveFrom(String aFromPath) {
        PathMapBuilderImpl<T> theToPathMap = new PathMapBuilderImpl<T>(this.getDelimiter(), this.getType());
        PathMapImpl.retrieveFrom(this, aFromPath, theToPathMap);
        return theToPathMap;
    }

    public char getDelimiter() {
        return this._delimiter;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public Object toDataStructure(String aFromPath) {
        return PathMapImpl.toDataStructure(this, aFromPath);
    }

    private void fromPathMap(String aToPath, PathMap<?> aPathMap, Set<Object> aVisited) {
        if (!aVisited.contains(aPathMap)) {
            aVisited.add(aPathMap);
            String theRegex = "" + aPathMap.getDelimiter();
            if (SPECIAL_REGEX_CHARS.contains(theRegex)) {
                theRegex = ESCAPE + theRegex;
            }
            for (String ePath : aPathMap.paths()) {
                String eBasePath = aToPath + ePath.replaceAll(theRegex, this.getRootPath());
                Object eValue = aPathMap.get(ePath);
                this.fromValue(eBasePath, eValue, aVisited);
            }
            aVisited.remove(aPathMap);
        }
    }

    private void fromMap(String aToPath, Map<?, ?> aMap, Set<Object> aVisited) {
        if (!aVisited.contains(aMap)) {
            aVisited.add(aMap);
            for (Object eObj : aMap.keySet()) {
                String eKey = eObj instanceof String ? (String)eObj : (eObj != null ? eObj.toString() : null);
                String eBasePath = aToPath + this.getDelimiter() + eKey;
                Object eValue = aMap.get(eObj);
                if (this.IS_DEBUG_OUTPUT) {
                    System.out.println(aToPath + ": fromMap(): " + aMap.getClass().getName() + " := " + aMap.toString());
                }
                this.fromValue(eBasePath, eValue, aVisited);
            }
            aVisited.remove(aMap);
        }
    }

    private void fromKeys(String aToPath, Keys<?, ?> aKeys, Set<Object> aVisited) {
        if (!aVisited.contains(aKeys)) {
            aVisited.add(aKeys);
            for (Object eObj : aKeys.keySet()) {
                String eKey = eObj instanceof String ? (String)eObj : (eObj != null ? eObj.toString() : null);
                String eBasePath = aToPath + this.getDelimiter() + eKey;
                Object eValue = aKeys.get(eObj);
                this.fromValue(eBasePath, eValue, aVisited);
            }
            aVisited.remove(aKeys);
        }
    }

    private void fromCollection(String aToPath, Collection<?> aCollection, Set<Object> aVisited) {
        if (!aVisited.contains(aCollection)) {
            aVisited.add(aCollection);
            int index = 0;
            for (Object eValue : aCollection) {
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aCollection);
        }
    }

    private void fromArray(String aToPath, Object[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            for (Object eValue : aArray) {
                String eBasePath = aToPath + this.getDelimiter() + index;
                if (this.IS_DEBUG_OUTPUT) {
                    System.out.println(aToPath + ": fromArray(): " + aArray.getClass().getName() + " := " + aArray.toString());
                }
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, boolean[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray) && !aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            boolean[] blArray = aArray;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean eValue = blArray[i];
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, byte[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            byte[] byArray = aArray;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte eValue = byArray[i];
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, char[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            char[] cArray = aArray;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character eValue = Character.valueOf(cArray[i]);
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, short[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            short[] sArray = aArray;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short eValue = sArray[i];
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, int[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            int[] nArray = aArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer eValue = nArray[i];
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, long[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            long[] lArray = aArray;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long eValue = lArray[i];
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, float[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            float[] fArray = aArray;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float eValue = Float.valueOf(fArray[i]);
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, double[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            double[] dArray = aArray;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double eValue = dArray[i];
                String eBasePath = aToPath + this.getDelimiter() + index;
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromObject(String aToPath, Object aObj, Set<Object> aVisited) {
        if (!aVisited.contains(aObj)) {
            aVisited.add(aObj);
            if (this._type.isAssignableFrom(aObj.getClass())) {
                this.put(aToPath, aObj);
            } else if (this._type.isAssignableFrom(String.class) && (Number.class.isAssignableFrom(aObj.getClass()) || Boolean.class.isAssignableFrom(aObj.getClass()))) {
                String theValue = aObj.toString();
                if (theValue.endsWith(".0")) {
                    theValue = theValue.substring(0, theValue.length() - 2);
                }
                this.put(aToPath, (T)theValue);
            } else if (this._type.isAssignableFrom(String.class) && Character.class.isAssignableFrom(aObj.getClass())) {
                String theValue = aObj.toString();
                this.put(aToPath, (T)theValue);
            } else if (this._type.isAssignableFrom(String.class) && Enum.class.isAssignableFrom(aObj.getClass())) {
                String theValue = ((Enum)aObj).name();
                this.put(aToPath, (T)theValue);
            } else if (this._type.isAssignableFrom(String.class) && Class.class.isAssignableFrom(aObj.getClass())) {
                String theValue = ((Class)aObj).getName();
                this.put(aToPath, (T)theValue);
            } else {
                Field[] theFields;
                Object eInvoked;
                String ePropertyName;
                HashMap<String, Object> theMap = new HashMap<String, Object>();
                Method[] theMethods = aObj.getClass().getMethods();
                if (theMethods != null && theMethods.length > 0) {
                    for (Method eMethod : theMethods) {
                        if (!TypeUtility.isGetter(eMethod)) continue;
                        try {
                            ePropertyName = TypeUtility.fromGetter(eMethod);
                            if (this.isBlackListed(ePropertyName) || theMap.containsKey(ePropertyName) || (eInvoked = eMethod.invoke(aObj, new Object[0])) == null || aVisited.contains(eInvoked)) continue;
                            theMap.put(ePropertyName, eInvoked);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                }
                if ((theFields = aObj.getClass().getDeclaredFields()) != null && theFields.length > 0) {
                    for (Field eField : theFields) {
                        try {
                            ePropertyName = TypeUtility.toPropertyName(eField);
                            if (this.isBlackListed(ePropertyName) || theMap.containsKey(ePropertyName) || (eInvoked = eField.get(aObj)) == null || aVisited.contains(eInvoked)) continue;
                            theMap.put(ePropertyName, eInvoked);
                        }
                        catch (IllegalAccessException | IllegalArgumentException exception) {
                            // empty catch block
                        }
                    }
                }
                if (!theMap.isEmpty()) {
                    if (this.IS_DEBUG_OUTPUT) {
                        System.out.println(aToPath + ": fromObject(): " + aObj.getClass().getName() + " := " + aObj.toString());
                    }
                    this.fromValue(aToPath, theMap, aVisited);
                }
            }
            aVisited.remove(aObj);
        }
    }

    private boolean isBlackListed(String aPropertyName) {
        for (String eBlackListed : BLACKLISTED_PROPERTIES) {
            if (!eBlackListed.equals(aPropertyName)) continue;
            return true;
        }
        return false;
    }

    private void fromValue(String aToPath, Object aValue, Set<Object> aVisited) {
        aToPath = this.toNormalizedPath(aToPath);
        if (aValue == null) {
            this.put(aToPath + Delimiter.PATH.getChar(), (T)null);
        } else if (aValue instanceof PathMap) {
            if (this.IS_DEBUG_OUTPUT) {
                System.out.println(aToPath + ": fromValue(): " + aValue.getClass().getName() + " := " + aValue.toString());
            }
            this.fromPathMap(aToPath, (PathMap)aValue, aVisited);
        } else if (aValue instanceof Map) {
            if (this.IS_DEBUG_OUTPUT) {
                System.out.println(aToPath + ": fromValue(): " + aValue.getClass().getName() + " := " + aValue.toString());
            }
            this.fromMap(aToPath, (Map)aValue, aVisited);
        } else if (aValue instanceof Keys) {
            this.fromKeys(aToPath, (Keys)aValue, aVisited);
        } else if (aValue instanceof Collection) {
            this.fromCollection(aToPath, (Collection)aValue, aVisited);
        } else if (aValue.getClass().isArray()) {
            Class<?> theType = aValue.getClass().getComponentType();
            if (theType.equals(Boolean.TYPE)) {
                this.fromArray(aToPath, (boolean[])aValue, aVisited);
            } else if (theType.equals(Byte.TYPE)) {
                this.fromArray(aToPath, (byte[])aValue, aVisited);
            } else if (theType.equals(Character.TYPE)) {
                this.fromArray(aToPath, (char[])aValue, aVisited);
            } else if (theType.equals(Short.TYPE)) {
                this.fromArray(aToPath, (short[])aValue, aVisited);
            } else if (theType.equals(Integer.TYPE)) {
                this.fromArray(aToPath, (int[])aValue, aVisited);
            } else if (theType.equals(Long.TYPE)) {
                this.fromArray(aToPath, (long[])aValue, aVisited);
            } else if (theType.equals(Float.TYPE)) {
                this.fromArray(aToPath, (float[])aValue, aVisited);
            } else if (theType.equals(Double.TYPE)) {
                if (this.IS_DEBUG_OUTPUT) {
                    System.out.println(aToPath + ": fromValue(): " + aValue.getClass().getName() + " := " + aValue.toString());
                }
                this.fromArray(aToPath, (double[])aValue, aVisited);
            } else {
                if (this.IS_DEBUG_OUTPUT) {
                    System.out.println(aToPath + ": fromValue(): " + aValue.getClass().getName() + " := " + aValue.toString());
                }
                this.fromArray(aToPath, (Object[])aValue, aVisited);
            }
        } else {
            this.fromObject(aToPath, aValue, aVisited);
        }
    }
}

