/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.structure;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.refcodes.structure.PathMap;
import org.refcodes.structure.PathMapBuilderImpl;

public class PathMapImpl<T>
implements PathMap<T> {
    private PathMap<T> _pathMap;

    protected PathMapImpl(PathMap<T> aPathMap) {
        this._pathMap = new PathMapBuilderImpl(aPathMap, aPathMap.getDelimiter(), aPathMap.getType());
    }

    public PathMapImpl(char aDelimiter, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aDelimiter, aType);
    }

    public PathMapImpl(Object aObj, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aObj, aType);
    }

    public PathMapImpl(String aToPath, Object aObj, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aToPath, aObj, aType);
    }

    public PathMapImpl(Object aObj, String aFromPath, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aObj, aFromPath, aType);
    }

    public PathMapImpl(String aToPath, Object aObj, String aFromPath, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aToPath, aObj, aFromPath, aType);
    }

    public PathMapImpl(Object aObj, char aDelimiter, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aObj, aDelimiter, aType);
    }

    public PathMapImpl(String aToPath, Object aObj, char aDelimiter, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aToPath, aObj, aDelimiter, aType);
    }

    public PathMapImpl(Object aObj, String aFromPath, char aDelimiter, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aObj, aFromPath, aDelimiter, aType);
    }

    public PathMapImpl(String aToPath, Object aObj, String aFromPath, char aDelimiter, Class<T> aType) {
        this._pathMap = new PathMapBuilderImpl<T>(aToPath, aObj, aFromPath, aDelimiter, aType);
    }

    @Override
    public boolean containsKey(Object aKey) {
        return this._pathMap.containsKey(aKey);
    }

    @Override
    public boolean containsValue(Object aValue) {
        return this._pathMap.containsValue(aValue);
    }

    @Override
    public T get(Object aKey) {
        return (T)this._pathMap.get(aKey);
    }

    @Override
    public Set<String> keySet() {
        return this._pathMap.keySet();
    }

    @Override
    public Collection<T> values() {
        return this._pathMap.values();
    }

    @Override
    public int size() {
        return this._pathMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._pathMap.isEmpty();
    }

    public char getDelimiter() {
        return this._pathMap.getDelimiter();
    }

    @Override
    public PathMap<T> retrieveFrom(String aFromPath) {
        return this._pathMap.retrieveFrom(aFromPath);
    }

    @Override
    public PathMap<T> retrieveTo(String aToPath) {
        return this._pathMap.retrieveTo(aToPath);
    }

    @Override
    public PathMap<T> childrenOf(String aParentPath) {
        return this._pathMap.childrenOf(aParentPath);
    }

    public Class<T> getType() {
        return this._pathMap.getType();
    }

    @Override
    public Object toDataStructure(String aFromPath) {
        return this._pathMap.toDataStructure();
    }

    public static Object toDataStructure(PathMap<?> aPathMap, String aFromPath) {
        return PathMapImpl.toArray(aPathMap.toMap(aFromPath));
    }

    public static <T> void retrieveFrom(PathMap<T> aFromPathMap, String aFromPath, PathMap.PathMapBuilder<T> aToPathMap) {
        aFromPath = aFromPathMap.toNormalizedPath(aFromPath);
        for (String ePath : aFromPathMap.paths()) {
            String eToPath;
            if (!ePath.startsWith(aFromPath) || !(eToPath = ePath.substring(aFromPath.length())).startsWith(aFromPathMap.getRootPath())) continue;
            aToPathMap.put(eToPath, aFromPathMap.get(ePath));
        }
    }

    public static <T> void retrieveTo(PathMap<T> aFromPathMap, String aToPath, PathMap.PathMapBuilder<T> aToPathMap) {
        aToPath = aFromPathMap.toNormalizedPath(aToPath);
        for (String ePath : aFromPathMap.paths()) {
            aToPathMap.put(aToPath + ePath, aFromPathMap.get(ePath));
        }
    }

    public static <T> void childrenOf(PathMap<T> aFromPathMap, String aParentPath, PathMap.PathMapBuilder<T> aToPathMap) {
        aParentPath = aFromPathMap.toNormalizedPath(aParentPath);
        for (String ePath : aFromPathMap.paths()) {
            if (!ePath.startsWith(aParentPath)) continue;
            aToPathMap.put(ePath.substring(aParentPath.length()), aFromPathMap.get(ePath));
        }
    }

    protected static Object toArray(Map<String, ?> aMap) {
        int index;
        int theMax = -1;
        for (String eKey : aMap.keySet()) {
            try {
                index = Integer.valueOf(eKey);
                if (index < 0) {
                    return PathMapImpl.toMap(aMap);
                }
                if (index <= theMax) continue;
                theMax = index;
            }
            catch (NumberFormatException e) {
                return PathMapImpl.toMap(aMap);
            }
        }
        Object[] theObjects = new Object[theMax + 1];
        for (String eKey : aMap.keySet()) {
            try {
                index = Integer.valueOf(eKey);
                theObjects[index] = PathMapImpl.toValue(aMap.get(eKey));
            }
            catch (NumberFormatException e) {
                return PathMapImpl.toMap(aMap);
            }
        }
        return theObjects;
    }

    protected static Map<String, ?> toMap(Map<String, ?> aMap) {
        HashMap<String, Object> theMap = new HashMap<String, Object>();
        for (String eKey : aMap.keySet()) {
            theMap.put(eKey, PathMapImpl.toValue(aMap.get(eKey)));
        }
        return theMap;
    }

    protected static Object toValue(Object aObj) {
        if (aObj instanceof Map) {
            return PathMapImpl.toArray((Map)aObj);
        }
        return aObj;
    }
}

