/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.structure;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.refcodes.data.Text;
import org.refcodes.structure.PathMap;
import org.refcodes.structure.PropertiesAccessorMixin;
import org.refcodes.structure.Relation;
import org.refcodes.structure.TypeUtility;

public interface CanonicalMap
extends PathMap<String>,
PropertiesAccessorMixin {
    public static final String DEFAULT_COMMENT = "Generated by <" + Text.REFCODES_ORG + "> (http://www.refcodes.org)";

    default public <T> T toType(Class<T> aType) {
        return this.toType(this.getRootPath(), aType);
    }

    default public <T> T toType(String aFromPath, Class<T> aType) {
        try {
            Object theDataStructure = this.toDataStructure(aFromPath);
            try {
                String theClassName = (String)this.get(aFromPath);
                Class<?> theType = Class.forName(theClassName);
                if (theType != null && aType.isAssignableFrom(theType)) {
                    aType = theType;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TypeUtility.toType(theDataStructure, aType);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create an instance of type <" + aType.getClass().getName() + ">: " + e.getMessage(), e);
        }
    }

    default public <T> void toInstance(T aInstance) {
        this.toInstance(this.getRootPath(), aInstance);
    }

    default public <T> void toInstance(String aFromPath, T aInstance) {
        try {
            TypeUtility.toInstance(this.toDataStructure(aFromPath), aInstance);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot update the instance of type <" + aInstance.getClass().getName() + ">: " + e.getMessage(), e);
        }
    }

    @Override
    default public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public CanonicalMap retrieveFrom(String var1);

    public CanonicalMap retrieveTo(String var1);

    public CanonicalMap childrenOf(String var1);

    default public CanonicalMap retrieve(String aFromPath, String aToPath) {
        CanonicalMap thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    public static interface CanonicalMapBuilder
    extends PathMap.PathMapBuilder<String>,
    MutableCanonicalMap,
    PropertiesAccessorMixin.PropertiesBuilderMixin<CanonicalMapBuilder> {
        @Override
        default public CanonicalMapBuilder withPut(String aKey, String aValue) {
            this.put(aKey, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPut(Relation<String, String> aProperty) {
            this.put(aProperty);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutInteger(String aKey, Integer aValue) {
            this.putInteger(aKey, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutShort(String aKey, Short aValue) {
            this.putShort(aKey, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutByte(String aKey, Byte aValue) {
            this.putByte(aKey, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDouble(String aKey, Double aValue) {
            this.putDouble(aKey, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutFloat(String aKey, Float aValue) {
            this.putFloat(aKey, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutBoolean(String aKey, Boolean aValue) {
            this.putBoolean(aKey, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutLong(String aKey, Long aValue) {
            this.putLong(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withInsert(Object aObj) {
            this.insert(aObj);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(Object aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(String aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withInsert(String aToPath, Object aFrom, String aFromPath) {
            this.insert(aToPath, aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withRemoveFrom(String aPath) {
            this.removeAll(aPath);
            return this;
        }

        default public CanonicalMapBuilder withInsert(CanonicalMap aFrom) {
            return this.withInsert((Object)aFrom);
        }

        default public CanonicalMapBuilder withInsertFrom(CanonicalMap aFrom, String aFromPath) {
            return this.withInsertFrom((Object)aFrom, aFromPath);
        }

        default public CanonicalMapBuilder withInsertTo(String aToPath, CanonicalMap aFrom) {
            return this.withInsertTo(aToPath, (Object)aFrom);
        }

        default public CanonicalMapBuilder withInsert(String aToPath, CanonicalMap aFrom, String aFromPath) {
            return this.withInsert(aToPath, (Object)aFrom, aFromPath);
        }
    }

    public static interface MutableCanonicalMap
    extends CanonicalMap,
    PathMap.MutablePathMap<String>,
    PropertiesAccessorMixin.PropertiesMutatorMixin,
    Map<String, String> {
        @Override
        default public String put(Relation<String, String> aRelation) {
            return (String)this.put((String)aRelation.getKey(), (String)aRelation.getValue());
        }

        @Override
        default public String delete(String aKey) {
            return (String)this.remove(aKey);
        }

        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        default public void putAll(Map<? extends String, ? extends String> aProperties) {
            for (String string : aProperties.keySet()) {
                this.put(string, (String)this.get(string));
            }
        }

        default public void putAll(CanonicalMap aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)this.get((String)eKey));
            }
        }

        default public void putAll(Properties aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)this.get((String)eKey));
            }
        }

        default public String toSourceCode() {
            return this.toSourceCode(null, null);
        }

        default public String toSourceCode(String aClassName, String aPackage) {
            if (aClassName == null || aClassName.length() == 0) {
                aClassName = "Foo";
            }
            StringBuffer theBuffer = new StringBuffer();
            if (aPackage != null && aPackage.length() != 0) {
                theBuffer.append("package " + aPackage + ";" + System.lineSeparator());
            }
            theBuffer.append(System.lineSeparator());
            theBuffer.append("import " + this.getClass().getName() + ";" + System.lineSeparator());
            theBuffer.append("import " + this.getType().getName() + ";" + System.lineSeparator());
            theBuffer.append(System.lineSeparator());
            theBuffer.append("public class " + aClassName + " extends " + this.getClass().getSimpleName() + " {" + System.lineSeparator());
            theBuffer.append(System.lineSeparator());
            ArrayList theKeys = new ArrayList(this.keySet());
            Collections.sort(theKeys);
            HashSet<String> theArrays = new HashSet<String>();
            for (String eKey : theKeys) {
                boolean isArray = false;
                if (this.hasParentPath(eKey)) {
                    String eParent = this.toParentPath(eKey);
                    if (theArrays.contains(eParent)) continue;
                    if (this.isArray(eParent)) {
                        theArrays.add(eParent);
                        eKey = eParent;
                        isArray = true;
                    }
                }
                StringBuffer ePropertyBuffer = new StringBuffer();
                boolean hadDelimiter = false;
                for (int i = 0; i < eKey.length(); ++i) {
                    char eChar = eKey.charAt(i);
                    if (eChar == this.getDelimiter()) {
                        hadDelimiter = true;
                        continue;
                    }
                    if (!Character.isAlphabetic(eChar) && !Character.isDigit(eChar)) continue;
                    if (hadDelimiter) {
                        ePropertyBuffer.append(Character.toUpperCase(eChar));
                    } else {
                        ePropertyBuffer.append(eChar);
                    }
                    hadDelimiter = false;
                }
                String ePropertyName = ePropertyBuffer.toString();
                if (isArray) {
                    theBuffer.append("\tpublic " + this.getType().getSimpleName() + "[] get" + ePropertyName + "() {" + System.lineSeparator());
                    theBuffer.append("\t\treturn getArray( \"" + eKey + "\" );" + System.lineSeparator());
                    theBuffer.append("\t}" + System.lineSeparator());
                    theBuffer.append(System.lineSeparator());
                    theBuffer.append("\tpublic void set" + ePropertyName + "(  " + this.getType().getSimpleName() + "[] aValues ) {" + System.lineSeparator());
                    theBuffer.append("\t\tputArray( \"" + eKey + "\", aValues );" + System.lineSeparator());
                    theBuffer.append("\t}" + System.lineSeparator());
                    theBuffer.append(System.lineSeparator());
                    continue;
                }
                theBuffer.append("\tpublic " + this.getType().getSimpleName() + " get" + ePropertyName + "() {" + System.lineSeparator());
                theBuffer.append("\t\treturn get( \"" + eKey + "\" );" + System.lineSeparator());
                theBuffer.append("\t}" + System.lineSeparator());
                theBuffer.append(System.lineSeparator());
                theBuffer.append("\tpublic void set" + ePropertyName + "( " + this.getType().getSimpleName() + " aValue ) {" + System.lineSeparator());
                theBuffer.append("\t\tput( \"" + eKey + "\", aValue );" + System.lineSeparator());
                theBuffer.append("\t}" + System.lineSeparator());
                theBuffer.append(System.lineSeparator());
            }
            theBuffer.append("}");
            return theBuffer.toString();
        }

        default public Map<String, String> toDump(Map<String, String> aDump) {
            aDump.putAll(this);
            return aDump;
        }

        default public void insert(CanonicalMap aFrom) {
            this.insert(aFrom);
        }

        default public void insertFrom(CanonicalMap aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
        }

        default public void insertTo(String aToPath, CanonicalMap aFrom) {
            this.insertTo(aToPath, aFrom);
        }

        default public void insert(String aToPath, CanonicalMap aFrom, String aFromPath) {
            this.insert(aToPath, aFrom, aFromPath);
        }
    }
}

