/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.structure;

import org.refcodes.data.Literal;
import org.refcodes.data.Literals;
import org.refcodes.structure.KeyNotFoundException;
import org.refcodes.structure.Keys;
import org.refcodes.structure.Property;

public interface PropertiesAccessorMixin
extends Keys<String, String> {
    default public Character getCharacter(String aKey) throws NumberFormatException {
        String theValue = (String)this.get(aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue.length() == 1) {
            return Character.valueOf(theValue.charAt(0));
        }
        throw new NumberFormatException("Unable to convert <" + theValue + "> to a character!");
    }

    default public Integer getInteger(String aKey) throws NumberFormatException {
        String theValue = (String)this.get(aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue.endsWith(".0")) {
            theValue = theValue.substring(0, theValue.length() - 2);
        }
        return Integer.valueOf(theValue);
    }

    default public Long getLong(String aKey) throws NumberFormatException {
        String theValue = (String)this.get(aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue.endsWith(".0")) {
            theValue = theValue.substring(0, theValue.length() - 2);
        }
        return Long.valueOf(theValue);
    }

    default public Short getShort(String aKey) throws NumberFormatException {
        String theValue = (String)this.get(aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue.endsWith(".0")) {
            theValue = theValue.substring(0, theValue.length() - 2);
        }
        return Short.valueOf(theValue);
    }

    default public Byte getByte(String aKey) throws NumberFormatException {
        String theValue = (String)this.get(aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue.endsWith(".0")) {
            theValue = theValue.substring(0, theValue.length() - 2);
        }
        return Byte.valueOf(theValue);
    }

    default public Double getDouble(String aKey) throws NumberFormatException {
        return Double.valueOf((String)this.get(aKey));
    }

    default public Float getFloat(String aKey) throws NumberFormatException {
        return Float.valueOf((String)this.get(aKey));
    }

    default public Boolean getBoolean(String aKey) throws NumberFormatException {
        String theValue = (String)this.get(aKey);
        if (theValue == null) {
            return false;
        }
        for (String eTrue : Literals.TRUE.getNames()) {
            if (!eTrue.equalsIgnoreCase(theValue)) continue;
            return true;
        }
        for (String eFalse : Literals.FALSE.getNames()) {
            if (!eFalse.equalsIgnoreCase(theValue)) continue;
            return false;
        }
        throw new NumberFormatException("Unable to parse a Boolean from the String <" + theValue + "> !");
    }

    default public boolean containsKey(Enum<?> aKey) {
        return this.containsKey(aKey.toString());
    }

    default public String get(Enum<?> aKey) {
        return (String)this.get(aKey.toString());
    }

    default public Character getCharacter(Enum<?> aKey) throws NumberFormatException {
        return this.getCharacter(aKey.toString());
    }

    default public Integer getInteger(Enum<?> aKey) throws NumberFormatException {
        return this.getInteger(aKey.toString());
    }

    default public Short getShort(Enum<?> aKey) throws NumberFormatException {
        return this.getShort(aKey.toString());
    }

    default public Byte getByte(Enum<?> aKey) throws NumberFormatException {
        return this.getByte(aKey.toString());
    }

    default public Double getDouble(Enum<?> aKey) throws NumberFormatException {
        return this.getDouble(aKey.toString());
    }

    default public Float getFloat(Enum<?> aKey) throws NumberFormatException {
        return this.getFloat(aKey.toString());
    }

    default public Boolean getBoolean(Enum<?> aKey) throws NumberFormatException {
        return this.getBoolean(aKey.toString());
    }

    default public Long getLong(Enum<?> aKey) throws NumberFormatException {
        return this.getLong(aKey.toString());
    }

    default public Integer useInteger(String aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey, "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getInteger(aKey);
    }

    default public Long useLong(String aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey, "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getLong(aKey);
    }

    default public Short useShort(String aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey, "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getShort(aKey);
    }

    default public Byte useByte(String aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey, "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getByte(aKey);
    }

    default public Double useDouble(String aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey, "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getDouble(aKey);
    }

    default public Float useFloat(String aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey, "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getFloat(aKey);
    }

    default public Boolean useBoolean(String aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey, "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getBoolean(aKey);
    }

    @Override
    default public String use(Enum<?> aKey) throws KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.get(aKey);
    }

    default public Integer useInteger(Enum<?> aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getInteger(aKey);
    }

    default public Short useShort(Enum<?> aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getShort(aKey);
    }

    default public Byte useByte(Enum<?> aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getByte(aKey);
    }

    default public Double useDouble(Enum<?> aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getDouble(aKey);
    }

    default public Float useFloat(Enum<?> aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getFloat(aKey);
    }

    default public Boolean useBoolean(Enum<?> aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getBoolean(aKey);
    }

    default public Long useLong(Enum<?> aKey) throws NumberFormatException, KeyNotFoundException {
        if (!this.containsKey(aKey)) {
            throw new KeyNotFoundException(aKey.toString(), "There is no such element with key <" + aKey + "> found in this instance!");
        }
        return this.getLong(aKey);
    }

    public static interface PropertiesBuilderMixin<T>
    extends PropertiesMixin {
        default public T withPut(String aKey, String aValue) {
            this.put(aKey, aValue);
            return (T)this;
        }

        default public T withPut(Property aProperty) {
            this.put(aProperty);
            return (T)this;
        }

        default public T withPutInteger(String aKey, Integer aValue) {
            this.putInteger(aKey, aValue);
            return (T)this;
        }

        default public T withPutShort(String aKey, Short aValue) {
            this.putShort(aKey, aValue);
            return (T)this;
        }

        default public T withPutByte(String aKey, Byte aValue) {
            this.putByte(aKey, aValue);
            return (T)this;
        }

        default public T withPutDouble(String aKey, Double aValue) {
            this.putDouble(aKey, aValue);
            return (T)this;
        }

        default public T withPutFloat(String aKey, Float aValue) {
            this.putFloat(aKey, aValue);
            return (T)this;
        }

        default public T withPutLong(String aKey, Long aValue) {
            this.putLong(aKey, aValue);
            return (T)this;
        }

        default public T withPutBoolean(String aKey, Boolean aValue) {
            this.putBoolean(aKey, aValue);
            return (T)this;
        }
    }

    public static interface PropertiesMixin
    extends PropertiesAccessorMixin,
    PropertiesMutatorMixin {
    }

    public static interface PropertiesMutatorMixin
    extends Keys.MutableValues<String, String> {
        default public String putInteger(String aKey, Integer aValue) {
            return this.put(aKey, aValue.toString());
        }

        default public String putShort(String aKey, Short aValue) {
            return this.put(aKey, aValue.toString());
        }

        default public String putByte(String aKey, Byte aValue) {
            return this.put(aKey, aValue.toString());
        }

        default public String putDouble(String aKey, Double aValue) {
            return this.put(aKey, aValue.toString());
        }

        default public String putFloat(String aKey, Float aValue) {
            return this.put(aKey, aValue.toString());
        }

        default public String putBoolean(String aKey, Boolean aValue) {
            return this.put(aKey, Boolean.TRUE.equals(aValue) ? Literal.TRUE.getName() : Literal.FALSE.getName());
        }

        default public String putLong(String aKey, Long aValue) {
            return this.put(aKey, aValue.toString());
        }

        default public String put(Property aProperty) {
            return this.put((String)aProperty.getKey(), (String)aProperty.getValue());
        }

        @Override
        default public String put(Enum<?> aKey, String aValue) {
            return this.put(aKey.toString(), aValue);
        }

        default public String putInteger(Enum<?> aKey, Integer aValue) {
            return this.putInteger(aKey.toString(), aValue);
        }

        default public String putShort(Enum<?> aKey, Short aValue) {
            return this.putShort(aKey.toString(), aValue);
        }

        default public String putByte(Enum<?> aKey, Byte aValue) {
            return this.putByte(aKey.toString(), aValue);
        }

        default public String putDouble(Enum<?> aKey, Double aValue) {
            return this.putDouble(aKey.toString(), aValue);
        }

        default public String putFloat(Enum<?> aKey, Float aValue) {
            return this.putFloat(aKey.toString(), aValue);
        }

        default public String putBoolean(Enum<?> aKey, Boolean aValue) {
            return this.putBoolean(aKey.toString(), aValue);
        }

        default public String putLong(Enum<?> aKey, Long aValue) {
            return this.putLong(aKey.toString(), aValue);
        }
    }
}

