/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.structure;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.refcodes.data.Literal;

public class TypeUtility {
    private static String[] SETTER_PREFIXES = new String[]{"set"};
    private static String[] GETTER_PREFIXES = new String[]{"is", "has", "get"};
    private static String[] FIELD_PREFIXES = new String[]{"_"};

    public static <T> T toType(Object aValue, Class<T> aType) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException, ClassNotFoundException {
        T theToInstance = aType.isArray() ? TypeUtility.toArray(aValue, aType) : TypeUtility.toInstance(aValue, aType);
        return theToInstance;
    }

    public static <T> void toInstance(Object aValue, T aInstance) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException, ClassNotFoundException {
        Class<?> theClass = aInstance.getClass();
        if (theClass.isArray()) {
            Object theInstance = TypeUtility.toArray(aValue, theClass);
            int fromLength = Array.getLength(theInstance);
            int toLength = Array.getLength(aInstance);
            for (int i = 0; i < fromLength && i < toLength; ++i) {
                Array.set(aInstance, i, Array.get(theInstance, i));
            }
        } else {
            TypeUtility.updateInstance(aValue, aInstance);
        }
    }

    public static boolean isSetter(Method aMethod) {
        String thePropertyName = TypeUtility.fromSetter(aMethod);
        if (thePropertyName == null || thePropertyName.length() == 0) {
            return false;
        }
        return Modifier.isPublic(aMethod.getModifiers()) && aMethod.getParameterCount() == 1 && Void.TYPE.equals(aMethod.getReturnType());
    }

    public static boolean isGetter(Method aMethod) {
        String thePropertyName = TypeUtility.fromGetter(aMethod);
        if (thePropertyName == null || thePropertyName.length() == 0) {
            return false;
        }
        return Modifier.isPublic(aMethod.getModifiers()) && aMethod.getParameterCount() == 0 && !Void.TYPE.equals(aMethod.getReturnType());
    }

    public static String toPropertyName(Method aMethod) {
        if (TypeUtility.isSetter(aMethod)) {
            return TypeUtility.fromSetter(aMethod);
        }
        if (TypeUtility.isGetter(aMethod)) {
            return TypeUtility.fromGetter(aMethod);
        }
        return null;
    }

    public static String toPropertyName(Field aField) {
        String theName = aField.getName();
        for (String ePrefix : FIELD_PREFIXES) {
            if (!theName.startsWith(ePrefix)) continue;
            theName = theName.substring(ePrefix.length());
            break;
        }
        if (theName.length() > 0) {
            return TypeUtility.toPropertyName(theName);
        }
        return null;
    }

    private static <T> T toInstance(Object aValue, Class<T> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (aValue instanceof String) {
            try {
                Class<?> theClass = Class.forName((String)aValue);
                if (aType.isAssignableFrom(theClass)) {
                    Constructor<?> theCtor2 = theClass.getConstructor(new Class[0]);
                    return (T)theCtor2.newInstance(new Object[0]);
                }
            }
            catch (Exception theClass) {
                // empty catch block
            }
        }
        Constructor<T> theCtor = aType.getConstructor(new Class[0]);
        try {
            theCtor.setAccessible(true);
        }
        catch (Exception theCtor2) {
            // empty catch block
        }
        T theToInstance = theCtor.newInstance(new Object[0]);
        TypeUtility.toInstance(aValue, theToInstance);
        return theToInstance;
    }

    private static <T> void updateInstance(Object aValue, T aInstance) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> aType = aInstance.getClass();
        if (aValue instanceof Map) {
            Field[] theFields;
            Map theMap = (Map)aValue;
            HashSet<String> theInjected = new HashSet<String>();
            Method[] theMethods = aType.getDeclaredMethods();
            if (theMethods != null && theMethods.length > 0) {
                for (Method eMethod : theMethods) {
                    if (!TypeUtility.isSetter(eMethod)) continue;
                    try {
                        Object eValue;
                        String ePropertyName = TypeUtility.fromSetter(eMethod);
                        if (theInjected.contains(ePropertyName) || (eValue = theMap.get(ePropertyName)) == null) continue;
                        try {
                            eMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (eValue.getClass().isArray() && !eMethod.getParameters()[0].getType().isArray() && !Collection.class.isAssignableFrom(eMethod.getParameters()[0].getType())) {
                            Object[] eArray = (Object[])eValue;
                            Object eObj = null;
                            for (Object eElement : eArray) {
                                if (eElement == null) continue;
                                if (eObj != null && eElement instanceof Map) {
                                    TypeUtility.updateInstance(eElement, eObj);
                                    continue;
                                }
                                eObj = TypeUtility.addToMethod(aInstance, eElement, eMethod);
                                theInjected.add(ePropertyName);
                            }
                            continue;
                        }
                        TypeUtility.addToMethod(aInstance, eValue, eMethod);
                        theInjected.add(ePropertyName);
                    }
                    catch (IllegalAccessException | IllegalArgumentException eValue) {
                        // empty catch block
                    }
                }
            }
            if ((theFields = aType.getDeclaredFields()) != null && theFields.length > 0) {
                for (Field eField : theFields) {
                    try {
                        Object eValue;
                        String ePropertyName = TypeUtility.toPropertyName(eField);
                        if (theInjected.contains(ePropertyName) || (eValue = theMap.get(ePropertyName)) == null) continue;
                        try {
                            eField.setAccessible(true);
                        }
                        catch (Exception eObj) {
                            // empty catch block
                        }
                        if (eValue.getClass().isArray() && !eField.getType().isArray() && !Collection.class.isAssignableFrom(eField.getType())) {
                            Object[] eArray;
                            for (Object eElement : eArray = (Object[])eValue) {
                                if (eElement == null) continue;
                                TypeUtility.addToField(aInstance, eElement, eField);
                                theInjected.add(ePropertyName);
                            }
                            continue;
                        }
                        TypeUtility.addToField(aInstance, eValue, eField);
                        theInjected.add(ePropertyName);
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static <T> Object addToMethod(T aToInstance, Object aToValue, Method aToMethod) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String theToValue = aToValue.toString();
        Class<?> theToType = aToMethod.getParameters()[0].getType();
        if (theToType.equals(String.class)) {
            aToMethod.invoke(aToInstance, theToValue);
        } else if (theToValue.length() != 0 && !Literal.NULL.getName().equals(theToValue)) {
            if (Number.class.isAssignableFrom(theToType) || Boolean.class.isAssignableFrom(theToType)) {
                Constructor<?> theCtor = theToType.getConstructor(String.class);
                try {
                    theCtor.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                aToMethod.invoke(aToInstance, theCtor.newInstance(theToValue));
            } else if (theToType.equals(Character.class)) {
                aToMethod.invoke(aToInstance, Character.valueOf(theToValue.charAt(0)));
            }
            if (Enum.class.isAssignableFrom(theToType)) {
                Object theEnumValue = Enum.valueOf(theToType, theToValue);
                aToMethod.invoke(aToInstance, theEnumValue);
            } else if (theToType.equals(Class.class)) {
                aToMethod.invoke(aToInstance, Class.forName(theToValue));
            } else if (theToType.equals(Boolean.TYPE)) {
                aToMethod.invoke(aToInstance, Boolean.parseBoolean(theToValue));
            } else if (theToType.equals(Byte.TYPE)) {
                aToMethod.invoke(aToInstance, Byte.parseByte(theToValue));
            } else if (theToType.equals(Character.TYPE)) {
                aToMethod.invoke(aToInstance, Character.valueOf(theToValue.charAt(0)));
            } else if (theToType.equals(Short.TYPE)) {
                aToMethod.invoke(aToInstance, Short.parseShort(theToValue));
            } else if (theToType.equals(Integer.TYPE)) {
                aToMethod.invoke(aToInstance, Integer.parseInt(theToValue));
            } else if (theToType.equals(Long.TYPE)) {
                aToMethod.invoke(aToInstance, Long.parseLong(theToValue));
            } else if (theToType.equals(Float.TYPE)) {
                aToMethod.invoke(aToInstance, Float.valueOf(Float.parseFloat(theToValue)));
            } else if (theToType.equals(Double.TYPE)) {
                aToMethod.invoke(aToInstance, Double.parseDouble(theToValue));
            } else if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toList(aToValue, aToMethod.getParameters()[0].getType(), aToMethod.getParameters()[0].getParameterizedType());
                aToMethod.invoke(aToInstance, theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMap(aToValue, aToMethod.getParameters()[0].getType(), aToMethod.getParameters()[0].getParameterizedType());
                aToMethod.invoke(aToInstance, theToMap);
            } else {
                Object theInstance = TypeUtility.toType(aToValue, theToType);
                aToMethod.invoke(aToInstance, theInstance);
                return theInstance;
            }
        }
        return null;
    }

    private static <T> void addToField(T aToInstance, Object aToValue, Field aToField) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        String theToValue = aToValue.toString();
        Class<?> theToType = aToField.getType();
        if (theToType.equals(String.class)) {
            aToField.set(aToInstance, theToValue);
        } else if (theToValue.length() != 0 && !Literal.NULL.getName().equals(theToValue)) {
            if (Number.class.isAssignableFrom(theToType) || Boolean.class.isAssignableFrom(theToType)) {
                Constructor<?> theCtor = theToType.getConstructor(String.class);
                try {
                    theCtor.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                aToField.set(aToInstance, theCtor.newInstance(theToValue));
            } else if (theToType.equals(Character.class)) {
                aToField.set(aToInstance, Character.valueOf(theToValue.charAt(0)));
            } else if (Enum.class.isAssignableFrom(theToType)) {
                Object theEnumValue = Enum.valueOf(theToType, theToValue);
                aToField.set(aToInstance, theEnumValue);
            } else if (theToType.equals(Class.class)) {
                aToField.set(aToInstance, Class.forName(theToValue));
            } else if (theToType.equals(Boolean.TYPE)) {
                aToField.setBoolean(aToInstance, Boolean.parseBoolean(theToValue));
            } else if (theToType.equals(Byte.TYPE)) {
                aToField.setByte(aToInstance, Byte.parseByte(theToValue));
            } else if (theToType.equals(Character.TYPE)) {
                aToField.setChar(aToInstance, theToValue.charAt(0));
            } else if (theToType.equals(Short.TYPE)) {
                aToField.setShort(aToInstance, Short.parseShort(theToValue));
            } else if (theToType.equals(Integer.TYPE)) {
                aToField.setInt(aToInstance, Integer.parseInt(theToValue));
            } else if (theToType.equals(Long.TYPE)) {
                aToField.setLong(aToInstance, Long.parseLong(theToValue));
            } else if (theToType.equals(Float.TYPE)) {
                aToField.setFloat(aToInstance, Float.parseFloat(theToValue));
            } else if (theToType.equals(Double.TYPE)) {
                aToField.setDouble(aToInstance, Double.parseDouble(theToValue));
            } else if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toList(aToValue, aToField.getType(), aToField.getGenericType());
                aToField.set(aToInstance, theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMap(aToValue, aToField.getType(), aToField.getGenericType());
                aToField.set(aToInstance, theToMap);
            } else {
                aToField.set(aToInstance, TypeUtility.toType(aToValue, theToType));
            }
        }
    }

    private static <T> T toArray(Object aValue, Class<T> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> theToType = aType.getComponentType();
        Object[] theArray = (Object[])aValue;
        Object theToInstance = Array.newInstance(aType.getComponentType(), theArray.length);
        for (int i = 0; i < theArray.length; ++i) {
            if (theArray[i] == null) continue;
            String eToValue = theArray[i].toString();
            if (theToType.equals(String.class)) {
                Array.set(theToInstance, i, eToValue);
                continue;
            }
            if (eToValue.length() == 0 || Literal.NULL.getName().equals(eToValue)) continue;
            if (Number.class.isAssignableFrom(theToType) || Boolean.class.isAssignableFrom(theToType)) {
                Constructor<?> theCtor = theToType.getConstructor(String.class);
                try {
                    theCtor.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Array.set(theToInstance, i, theCtor.newInstance(eToValue));
                continue;
            }
            if (theToType.equals(Character.class)) {
                Array.set(theToInstance, i, Character.valueOf(eToValue.charAt(0)));
                continue;
            }
            if (Enum.class.isAssignableFrom(theToType)) {
                Object theEnumValue = Enum.valueOf(theToType, eToValue);
                Array.set(theToInstance, i, theEnumValue);
                continue;
            }
            if (theToType.equals(Class.class)) {
                Array.set(theToInstance, i, Class.forName(eToValue));
                continue;
            }
            if (theToType.equals(Boolean.TYPE)) {
                Array.set(theToInstance, i, Boolean.parseBoolean(eToValue));
                continue;
            }
            if (theToType.equals(Byte.TYPE)) {
                Array.set(theToInstance, i, Byte.parseByte(eToValue));
                continue;
            }
            if (theToType.equals(Character.TYPE)) {
                Array.set(theToInstance, i, Character.valueOf(eToValue.charAt(0)));
                continue;
            }
            if (theToType.equals(Short.TYPE)) {
                Array.set(theToInstance, i, Short.parseShort(eToValue));
                continue;
            }
            if (theToType.equals(Integer.TYPE)) {
                Array.set(theToInstance, i, Integer.parseInt(eToValue));
                continue;
            }
            if (theToType.equals(Long.TYPE)) {
                Array.set(theToInstance, i, Long.parseLong(eToValue));
                continue;
            }
            if (theToType.equals(Float.TYPE)) {
                Array.set(theToInstance, i, Float.valueOf(Float.parseFloat(eToValue)));
                continue;
            }
            if (theToType.equals(Double.TYPE)) {
                Array.set(theToInstance, i, Double.parseDouble(eToValue));
                continue;
            }
            Array.set(theToInstance, i, TypeUtility.toType(theArray[i], theToType));
        }
        return (T)theToInstance;
    }

    private static Map<?, ?> toMap(Object aToValue, Class<?> aToType, Type aToGenericType) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Map theMap = (Map)aToValue;
        Map theToMap = aToType.equals(Map.class) ? new HashMap() : (Map)aToType.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class theKeyType = Object.class;
        Class theValueType = Object.class;
        if (aToGenericType instanceof ParameterizedType) {
            ParameterizedType theGenericType = (ParameterizedType)aToGenericType;
            theKeyType = TypeUtility.toClass(theGenericType.getActualTypeArguments()[0]);
            theValueType = TypeUtility.toClass(theGenericType.getActualTypeArguments()[1]);
        }
        for (Object eKey : theMap.keySet()) {
            Object theValue = theMap.get(eKey);
            if (theValue == null) continue;
            theToMap.put(TypeUtility.toValue(eKey, theKeyType), TypeUtility.toValue(theValue, theValueType));
        }
        return theMap;
    }

    private static List<?> toList(Object aToValue, Class<?> aToType, Type aToGenericType) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Object[] theArray = (Object[])aToValue;
        List theToList = aToType.equals(List.class) ? new ArrayList() : (List)aToType.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class theType = Object.class;
        if (aToGenericType instanceof ParameterizedType) {
            theType = TypeUtility.toClass(((ParameterizedType)aToGenericType).getActualTypeArguments()[0]);
        }
        for (int i = 0; i < theArray.length; ++i) {
            if (theArray[i] == null) {
                theToList.add(null);
                continue;
            }
            theToList.add(TypeUtility.toValue(theArray[i], theType));
        }
        return theToList;
    }

    private static Object toValue(Object aValue, Class<?> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String theValue = aValue.toString();
        Constable theResult = null;
        if (aType.equals(String.class)) {
            theResult = theValue;
        } else if (theValue.length() != 0 && !Literal.NULL.getName().equals(theValue)) {
            if (Number.class.isAssignableFrom(aType) || Boolean.class.isAssignableFrom(aType)) {
                Constructor<?> theCtor = aType.getConstructor(String.class);
                try {
                    theCtor.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                theResult = theCtor.newInstance(theValue);
            } else {
                theResult = aType.equals(Character.class) ? Character.valueOf(theValue.charAt(0)) : (aType.equals(Class.class) ? Class.forName(theValue) : TypeUtility.toType(aValue, aType));
            }
        }
        return theResult;
    }

    private static Class<?> toClass(Type aType) throws ClassNotFoundException {
        if (aType instanceof Class) {
            return (Class)aType;
        }
        return Class.forName(aType.getTypeName());
    }

    private static String toPropertyName(String aName) {
        char[] theChars = aName.toCharArray();
        for (int i = 0; i < theChars.length && Character.isUpperCase(theChars[i]); ++i) {
            theChars[i] = Character.toLowerCase(theChars[i]);
        }
        return new String(theChars);
    }

    private static String fromSetter(Method aMethod) {
        String ePrefix2;
        String theName;
        block4: {
            theName = aMethod.getName();
            for (String ePrefix2 : SETTER_PREFIXES) {
                if (!theName.startsWith(ePrefix2)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        theName = theName.substring(ePrefix2.length());
        if (theName.length() > 0) {
            if (Character.isLowerCase(theName.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(theName);
        }
        return null;
    }

    protected static String fromGetter(Method aMethod) {
        String ePrefix2;
        String theName;
        block4: {
            theName = aMethod.getName();
            for (String ePrefix2 : GETTER_PREFIXES) {
                if (!theName.startsWith(ePrefix2)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        theName = theName.substring(ePrefix2.length());
        if (theName.length() > 0) {
            if (Character.isLowerCase(theName.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(theName);
        }
        return null;
    }
}

