/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.IOException;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.CsvRecordsReader;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderImpl;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.ObjectColumn;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Row;
import org.refcodes.tabular.RowImpl;
import org.refcodes.tabular.RowsImpl;
import org.refcodes.tabular.StringColumn;
import org.refcodes.tabular.StringsColumn;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;

public class CsvReaderTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static Header<Object> HEADER = new HeaderImpl(new Column[]{new ObjectColumn("id", Integer.class), new StringColumn("alias"), new StringColumn("name"), new StringColumn("description"), new StringsColumn("array"), new ObjectColumn("details", Object[].class)});
    private static Row<Object>[] ROWS = new Row[]{new RowImpl(new Object[]{0, "alias0", "name0", "description0", new String[]{"01", "02", "03"}, new Object[]{"A", "B", "C"}}), new RowImpl(new Object[]{1, "alias1", "name1", "description1", new String[]{"04", "05", "06"}, new Object[]{"D", "E", "F"}}), new RowImpl(new Object[]{2, "alias2", "name2", "description2", new String[]{"07", "08", "09"}, new Object[]{"G", "H", "I"}}), new RowImpl(new Object[]{3, "alias3", "name3", "description3", new String[]{"10", "11", "12"}, new Object[]{"J", "K", "L"}}), new RowImpl(new Object[]{4, "alias4", "name4", "description4", new String[]{"13", "14", "15"}, new Object[]{"M", "N", "O"}}), new RowImpl(new Object[]{5, "alias5", "name5", "description5", new String[]{"16", "17", "18"}, new Object[]{"P", "Q", "R"}}), new RowImpl(new Object[]{6, "alias6", "name6", "description6", new String[]{"19", "20", "21"}, new Object[]{"S", "T", "U"}}), new RowImpl(new Object[]{7, "alias7", "name7", "description7", new String[]{"22", "23", "24"}, new Object[]{"V", "W", "X"}}), new RowImpl(new Object[]{8, "alias8", "name8", "description8", new String[]{"25", "26", "27"}, new Object[]{"Y", "Z", "\u00c4"}}), new RowImpl(new Object[]{9, "alias9", "name9", "description9", new String[]{"28", "29", "30"}, new Object[]{"\u00d6", "\u00dc", "\u00df"}})};

    @Test
    public void testCsvReader() throws IOException, ColumnMismatchException, HeaderMismatchException, IllegalStateException {
        InputStream theInputStream = this.getClass().getResourceAsStream("/records.csv");
        try (CsvRecordsReader eRecords = new CsvRecordsReader(HEADER, theInputStream);){
            RowsImpl eRows = new RowsImpl(HEADER, ROWS);
            if (IS_LOG_TESTS) {
                System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
            }
            while (eRecords.hasNext()) {
                Record eRecord = eRecords.next();
                if (IS_LOG_TESTS) {
                    System.out.println("Printable record := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.toPrintable(eRecord).values()}).toRecord());
                }
                Row eRow = (Row)eRows.next();
                Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.toStorageString(eRecord).values()}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.toStorageString(HEADER.toRecord(eRow)).values()}).toRecord());
            }
        }
    }
}

