/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.CsvStringRecordsReader;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.Record;

public class CsvStringReaderTest {
    @Test
    public void testCsvStringReader() throws FileNotFoundException, ZipException, IOException, URISyntaxException {
        URL theResource = this.getClass().getClassLoader().getResource("string_records.csv");
        File theFile = new File(theResource.getPath());
        try (CsvStringRecordsReader theReader = new CsvStringRecordsReader(theFile, ';');){
            Header theHeader = theReader.getHeader();
            int index = 0;
            for (Record eRecord : theReader) {
                for (Column eColumn : theHeader) {
                    Assertions.assertEquals((Object)(index + (String)eColumn.getKey()), (Object)eRecord.get(eColumn.getKey()));
                }
                for (String eKey : theHeader.keySet()) {
                    Assertions.assertEquals((Object)(index + eKey), (Object)eRecord.get((Object)eKey));
                }
                ++index;
            }
            Assertions.assertEquals((int)10, (int)index);
        }
    }
}

