/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderImpl;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.ObjectColumn;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Row;
import org.refcodes.tabular.RowImpl;
import org.refcodes.tabular.RowsImpl;
import org.refcodes.tabular.StringColumn;
import org.refcodes.tabular.StringsColumn;
import org.refcodes.tabular.TabularUtility;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;

public class HeaderTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static Header<Object> HEADER = new HeaderImpl(new Column[]{new ObjectColumn("id", Integer.class), new StringColumn("alias"), new StringColumn("name"), new StringColumn("description"), new StringsColumn("array"), new ObjectColumn("details", Object[].class)});
    private static Row<Object>[] ROWS = new Row[]{new RowImpl(new Object[]{0, "alias0", "name0", "description0", new String[]{"01", "02", "03"}, new Object[]{"A", "B", "C"}}), new RowImpl(new Object[]{1, "alias1", "name1", "description1", new String[]{"04", "05", "06"}, new Object[]{"D", "E", "F"}}), new RowImpl(new Object[]{2, "alias2", "name2", "description2", new String[]{"07", "08", "09"}, new Object[]{"G", "H", "I"}}), new RowImpl(new Object[]{3, "alias3", "name3", "description3", new String[]{"10", "11", "12"}, new Object[]{"J", "K", "L"}}), new RowImpl(new Object[]{4, "alias4", "name4", "description4", new String[]{"13", "14", "15"}, new Object[]{"M", "N", "O"}}), new RowImpl(new Object[]{5, "alias5", "name5", "description5", new String[]{"16", "17", "18"}, new Object[]{"P", "Q", "R"}}), new RowImpl(new Object[]{6, "alias6", "name6", "description6", new String[]{"19", "20", "21"}, new Object[]{"S", "T", "U"}}), new RowImpl(new Object[]{7, "alias7", "name7", "description7", new String[]{"22", "23", "24"}, new Object[]{"V", "W", "X"}}), new RowImpl(new Object[]{8, "alias8", "name8", "description8", new String[]{"25", "26", "27"}, new Object[]{"Y", "Z", "\u00c4"}}), new RowImpl(new Object[]{9, "alias9", "name9", "description9", new String[]{"28", "29", "30"}, new Object[]{"\u00d6", "\u00dc", "\u00df"}})};

    @Test
    public void testRowIsEquivalent1() throws HeaderMismatchException, ColumnMismatchException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing equality of rows with a header (1) ***".toUpperCase());
        }
        RowsImpl e = new RowsImpl(HEADER, ROWS);
        if (IS_LOG_TESTS) {
            System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
        }
        while (e.hasNext()) {
            Row eRow = (Row)e.next();
            Assertions.assertTrue((boolean)TabularUtility.isEqualWith((Row)eRow, HEADER));
            if (!IS_LOG_TESTS) continue;
            System.out.println("Row := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord());
        }
    }

    @Test
    public void testRowIsEquivalent2() {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing equality of rows with a header (2) ***".toUpperCase());
        }
        try {
            new RowsImpl(HEADER, new Row[]{new RowImpl(new Object[]{0, 2, "name1", "description1"})});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testStorageStringRecord() throws HeaderMismatchException, ColumnMismatchException, ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a record to a storage strings record and back ***".toUpperCase());
        }
        RowsImpl e = new RowsImpl(HEADER, ROWS);
        if (IS_LOG_TESTS) {
            System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
        }
        while (e.hasNext()) {
            Row eRow = (Row)e.next();
            Assertions.assertTrue((boolean)TabularUtility.isEqualWith((Row)eRow, HEADER));
            Record eRecord = HEADER.toRecord(eRow);
            Record eToStorageRecord = HEADER.toStorageString(eRecord);
            Record eFromStorageRecord = HEADER.fromStorageString(eToStorageRecord);
            if (IS_LOG_TESTS) {
                System.out.println("Record --> To storage record --> From storage record := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRecord.values()}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eToStorageRecord.values()}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRecord.values()}).toRecord());
            }
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRecord.keySet()}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRecord.keySet()}).toRecord());
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRecord.values()}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRecord.values()}).toRecord());
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((Collection)HEADER.toRow(eFromStorageRecord)).toRecord());
        }
    }

    @Test
    public void testStorageStringsRecord() throws HeaderMismatchException, ColumnMismatchException, ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a record to a storage string arrays record and back ***".toUpperCase());
        }
        RowsImpl e = new RowsImpl(HEADER, ROWS);
        if (IS_LOG_TESTS) {
            System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
        }
        while (e.hasNext()) {
            Row eRow = (Row)e.next();
            Assertions.assertTrue((boolean)TabularUtility.isEqualWith((Row)eRow, HEADER));
            Record eRecord = HEADER.toRecord(eRow);
            Record eToStorageRecord = HEADER.toStorageStrings(eRecord);
            Record eFromStorageRecord = HEADER.fromStorageStrings(eToStorageRecord);
            if (IS_LOG_TESTS) {
                System.out.println("Record --> To storage record --> From storage record := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRecord.values()}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eToStorageRecord.values()}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRecord.values()}).toRecord());
            }
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRecord.keySet()}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRecord.keySet()}).toRecord());
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRecord.values()}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRecord.values()}).toRecord());
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((Collection)HEADER.toRow(eFromStorageRecord)).toRecord());
        }
    }

    @Test
    public void testPrintableRecord() throws HeaderMismatchException, ColumnMismatchException, ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a record to a printable record ***".toUpperCase());
        }
        RowsImpl e = new RowsImpl(HEADER, ROWS);
        if (IS_LOG_TESTS) {
            System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
        }
        while (e.hasNext()) {
            Row eRow = (Row)e.next();
            Assertions.assertTrue((boolean)TabularUtility.isEqualWith((Row)eRow, HEADER));
            Record eRecord = HEADER.toRecord(eRow);
            Record eToPrintableRecord = HEADER.toPrintable(eRecord);
            if (!IS_LOG_TESTS) continue;
            System.out.println("Record --> To printable record := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRecord.values()}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eToPrintableRecord.values()}).toRecord());
        }
    }

    @Test
    public void testStorageStringRow() throws HeaderMismatchException, ColumnMismatchException, ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a row to a storage strings row and back ***".toUpperCase());
        }
        RowsImpl e = new RowsImpl(HEADER, ROWS);
        if (IS_LOG_TESTS) {
            System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
        }
        while (e.hasNext()) {
            Row eRow = (Row)e.next();
            Assertions.assertTrue((boolean)TabularUtility.isEqualWith((Row)eRow, HEADER));
            Row eToStorageRow = HEADER.toStorageString(eRow);
            Row eFromStorageRow = HEADER.fromStorageString(eToStorageRow);
            if (IS_LOG_TESTS) {
                System.out.println("Row --> To storage row --> From storage row := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eToStorageRow}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRow}).toRecord());
            }
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRow}).toRecord());
        }
    }

    @Test
    public void testStorageStringsRow() throws HeaderMismatchException, ColumnMismatchException, ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a row to a storage string arrays row and back ***".toUpperCase());
        }
        RowsImpl e = new RowsImpl(HEADER, ROWS);
        if (IS_LOG_TESTS) {
            System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
        }
        while (e.hasNext()) {
            Row eRow = (Row)e.next();
            Assertions.assertTrue((boolean)TabularUtility.isEqualWith((Row)eRow, HEADER));
            Row eToStorageRow = HEADER.toStorageStrings(eRow);
            Row eFromStorageRow = HEADER.fromStorageStrings(eToStorageRow);
            if (IS_LOG_TESTS) {
                System.out.println("Row --> To storage row --> From storage row := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eToStorageRow}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRow}).toRecord());
            }
            Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eFromStorageRow}).toRecord());
        }
    }

    @Test
    public void testPrintableRow() throws HeaderMismatchException, ColumnMismatchException, ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a row to a printable row ***".toUpperCase());
        }
        RowsImpl e = new RowsImpl(HEADER, ROWS);
        if (IS_LOG_TESTS) {
            System.out.println("Header := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.keySet()}).toRecord());
        }
        while (e.hasNext()) {
            Row eRow = (Row)e.next();
            Assertions.assertTrue((boolean)TabularUtility.isEqualWith((Row)eRow, HEADER));
            Row eToPrintableRow = HEADER.toPrintable(eRow);
            if (!IS_LOG_TESTS) continue;
            System.out.println("Row --> To storage row --> From storage row := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord() + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eToPrintableRow}).toRecord());
        }
    }

    @Test
    public void testToRow() throws HeaderMismatchException, ColumnMismatchException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a record to a row and back ***".toUpperCase());
        }
        Record theRecord = HEADER.toRecord(ROWS[0]);
        Row theRow = HEADER.toRow(theRecord);
        Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(ROWS[0]).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{theRow}).toRecord());
    }

    @Test
    public void testToRowIgnoreType() throws HeaderMismatchException, ColumnMismatchException {
        Row theRow;
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion ignoring types of a record to a row and back ***".toUpperCase());
        }
        Record theRecord = HEADER.toStorageStringRecord(ROWS[0]);
        try {
            theRow = HEADER.toRow(theRecord);
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (ColumnMismatchException columnMismatchException) {
            // empty catch block
        }
        theRow = HEADER.toRowIgnoreType(theRecord);
        Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.toStorageString(ROWS[0])}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{theRow}).toRecord());
    }

    @Test
    public void testToRecordIgnoreType() throws HeaderMismatchException, ColumnMismatchException {
        Record theRecord;
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion ignoring types of a row to a record and back ***".toUpperCase());
        }
        Row theRow = HEADER.toStorageString(ROWS[0]);
        try {
            theRecord = HEADER.toRecord(theRow);
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (ColumnMismatchException columnMismatchException) {
            // empty catch block
        }
        theRecord = HEADER.toRecordIgnoreType(theRow);
        Assertions.assertEquals((Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{theRow}).toRecord(), (Object)new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{HEADER.toRowIgnoreType(theRecord)}).toRecord());
    }
}

