/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.tabular.ObjectColumn;
import org.refcodes.tabular.StringColumn;
import org.refcodes.tabular.StringsColumn;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;

public class ColumnTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testIntegerColumn1() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of an integer value to a storage string and back ***".toUpperCase());
        }
        ObjectColumn theColumn = new ObjectColumn("value", Integer.class);
        Integer theValue = 5161;
        String theToStorageString = theColumn.toStorageString((Object)theValue);
        Integer theFromStorageString = (Integer)theColumn.fromStorageString(theToStorageString);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + theValue + " --> " + theToStorageString + " --> " + theFromStorageString);
        }
        Assertions.assertEquals((Integer)theValue, (Integer)theFromStorageString);
    }

    @Test
    public void testIntegerColumn2() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of an integer value to a storage string array and back ***".toUpperCase());
        }
        ObjectColumn theColumn = new ObjectColumn("value", Integer.class);
        Integer theValue = 5161;
        String[] theToStorageStrings = theColumn.toStorageStrings((Object)theValue);
        Integer theFromStorageString = (Integer)theColumn.fromStorageStrings(theToStorageStrings);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + theValue + " --> " + theToStorageStrings + " --> " + theFromStorageString);
        }
        Assertions.assertEquals((Integer)theValue, (Integer)theFromStorageString);
    }

    @Test
    public void testIntegersColumn1() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of an integer array to a storage string and back ***".toUpperCase());
        }
        ObjectColumn theColumn = new ObjectColumn("value", Integer[].class);
        Object[] theValues = new Integer[]{5, 1, 6, 1};
        String theToStorageString = theColumn.toStorageString((Object)theValues);
        Object[] theFromStorageStrings = (Integer[])theColumn.fromStorageString(theToStorageString);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((Integer[])theValues).toRecord() + " --> " + theToStorageString + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((Integer[])theFromStorageStrings).toRecord());
        }
        Assertions.assertArrayEquals((Object[])theValues, (Object[])theFromStorageStrings);
        for (int i = 0; i < theValues.length; ++i) {
            Assertions.assertEquals((Integer)theValues[i], (Integer)theFromStorageStrings[i]);
        }
    }

    @Test
    public void testIntegersColumn2() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of an integer array to a storage string array and back ***".toUpperCase());
        }
        ObjectColumn theColumn = new ObjectColumn("value", Integer[].class);
        Object[] theValues = new Integer[]{5, 1, 6, 1};
        String[] theToStorageStrings = theColumn.toStorageStrings((Object)theValues);
        Object[] theFromStorageStrings = (Integer[])theColumn.fromStorageStrings(theToStorageStrings);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((Integer[])theValues).toRecord() + " --> " + theToStorageStrings + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((Integer[])theFromStorageStrings).toRecord());
        }
        Assertions.assertArrayEquals((Object[])theValues, (Object[])theFromStorageStrings);
        for (int i = 0; i < theValues.length; ++i) {
            Assertions.assertEquals((Integer)theValues[i], (Integer)theFromStorageStrings[i]);
        }
    }

    @Test
    public void testStringColumn1() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a string value to a storage string and back ***".toUpperCase());
        }
        StringColumn theColumn = new StringColumn("value");
        String theValue = "This is a test text.";
        String theToStorageString = theColumn.toStorageString((Object)theValue);
        String theFromStorageString = (String)theColumn.fromStorageString(theToStorageString);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + theValue + " --> " + theToStorageString + " --> " + theFromStorageString);
        }
        Assertions.assertEquals((Object)theValue, (Object)theFromStorageString);
    }

    @Test
    public void testStringColumn2() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a string value to a storage string array and back ***".toUpperCase());
        }
        StringColumn theColumn = new StringColumn("value");
        String theValue = "This is a test text.";
        String[] theToStorageStrings = theColumn.toStorageStrings((Object)theValue);
        String theFromStorageString = (String)theColumn.fromStorageStrings(theToStorageStrings);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + theValue + " --> " + theToStorageStrings + " --> " + theFromStorageString);
        }
        Assertions.assertEquals((Object)theValue, (Object)theFromStorageString);
    }

    @Test
    public void testStringsColumn1() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a string array to a storage string and back ***".toUpperCase());
        }
        StringsColumn theColumn = new StringsColumn("value");
        Object[] theValues = new String[]{"A", "B", "C", "D"};
        String theToStorageString = theColumn.toStorageString((Object)theValues);
        Object[] theFromStorageStrings = (String[])theColumn.fromStorageString(theToStorageString);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((String[])theValues).toRecord() + " --> " + theToStorageString + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((String[])theFromStorageStrings).toRecord());
        }
        Assertions.assertArrayEquals((Object[])theValues, (Object[])theFromStorageStrings);
        for (int i = 0; i < theValues.length; ++i) {
            Assertions.assertEquals((Object)theValues[i], (Object)theFromStorageStrings[i]);
        }
    }

    @Test
    public void testStringsColumn2() throws ParseException {
        if (IS_LOG_TESTS) {
            System.out.println("*** Testing conversion of a string array to a storage string array and back ***".toUpperCase());
        }
        StringsColumn theColumn = new StringsColumn("value");
        Object[] theValues = new String[]{"A", "B", "C", "D"};
        String[] theToStorageStrings = theColumn.toStorageStrings((Object)theValues);
        Object[] theFromStorageStrings = (String[])theColumn.fromStorageStrings(theToStorageStrings);
        if (IS_LOG_TESTS) {
            System.out.println("Value --> To storage string --> From storage string := " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((String[])theValues).toRecord() + " --> " + theToStorageStrings + " --> " + new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((String[])theFromStorageStrings).toRecord());
        }
        Assertions.assertArrayEquals((Object[])theValues, (Object[])theFromStorageStrings);
        for (int i = 0; i < theValues.length; ++i) {
            Assertions.assertEquals((Object)theValues[i], (Object)theFromStorageStrings[i]);
        }
    }
}

