/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.refcodes.tabular.CsvStringRecordsReader;
import org.refcodes.tabular.CsvStringRecordsWriter;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class CsvStringWriterTest {
    @Test
    public void testCsvStringWriter1() throws IOException {
        String[][] theCsv = new String[][]{{"\"Hallo\"", "\"Du\"", "\"Welt\"", "\"Da!\""}, {"\"He\"llo\"", "\"You\"", "\"World\"", "\"There!\""}};
        ByteArrayOutputStream theOut = new ByteArrayOutputStream();
        try (CsvStringRecordsWriter theWriter = new CsvStringRecordsWriter((OutputStream)theOut);){
            theWriter.writeHeader(new String[]{"a", "b", "c", "d"});
            theWriter.writeNext(theCsv[0]);
            theWriter.writeNext(theCsv[1]);
            System.out.println(theOut.toString());
            ByteArrayInputStream theIn = new ByteArrayInputStream(theOut.toByteArray());
            try (CsvStringRecordsReader theReader = new CsvStringRecordsReader((InputStream)theIn);){
                int index = 0;
                VerboseTextBuilderImpl theVerbose = new VerboseTextBuilderImpl();
                while (theReader.hasNext()) {
                    Object[] eRecord = theReader.readNext();
                    System.out.println(index + ": " + theVerbose.toString(theCsv[index]));
                    System.out.println(index + ": " + theVerbose.toString((String[])eRecord));
                    Assert.assertArrayEquals((Object[])theCsv[index++], (Object[])eRecord);
                }
                Assert.assertEquals((long)theCsv.length, (long)index);
            }
        }
    }

    @Test
    public void testCsvStringWriter2() throws IOException {
        String[][] theCsv = new String[][]{{"\"Hallo\"", "\"Du\"", "\"Welt\"", "\"Da!\""}, {"\"He\"llo\"", "\"You\"", "\"World\"", "\"There!\""}};
        ByteArrayOutputStream theOut = new ByteArrayOutputStream();
        try (CsvStringRecordsWriter theWriter = new CsvStringRecordsWriter((OutputStream)theOut);){
            theWriter.writeHeader(new String[]{"a", "b", "c", "d"});
            theWriter.writeNext(theCsv[0]);
            theWriter.writeNext(theCsv[1]);
            System.out.println(theOut.toString());
            ByteArrayInputStream theIn = new ByteArrayInputStream(theOut.toByteArray());
            try (CsvStringRecordsReader theReader = new CsvStringRecordsReader((InputStream)theIn);){
                int index = 0;
                VerboseTextBuilderImpl theVerbose = new VerboseTextBuilderImpl();
                while (theReader.hasNext()) {
                    Object[] eRecord = (String[])theReader.getHeader().toValues(theReader.next());
                    System.out.println(index + ": " + theVerbose.toString(theCsv[index]));
                    System.out.println(index + ": " + theVerbose.toString((String[])eRecord));
                    Assert.assertArrayEquals((Object[])theCsv[index++], (Object[])eRecord);
                }
                Assert.assertEquals((long)theCsv.length, (long)index);
            }
        }
    }

    @Test
    public void testCsvStringWriter3() throws IOException {
        try (CsvStringRecordsWriter theWriter = new CsvStringRecordsWriter(System.out);){
            theWriter.writeHeader(new String[]{"a", "b", "c", "d", "e"});
            theWriter.writeNext(new String[]{"0a", "0b", "0c", "0d"});
            theWriter.writeNext(new String[]{"1a", "1b", "1c", "1d"});
            theWriter.writeNext(new String[]{"2a", "2b", "2c", "2d"});
            theWriter.writeNext(new String[]{"3a", "3b", "3c", "3d"});
            theWriter.writeNext(new String[]{"4a", "4b", "4c", "4d"});
            theWriter.writeNext(new String[]{"5a", "5b", "5c", "5d"});
            theWriter.writeNext(new String[]{"6a", "6b", "6c", "6d"});
            theWriter.writeNext(new String[]{"7a", "7b", "7c", "7d"});
            theWriter.writeNext(new String[]{"8a", "8b", "8c", "8d"});
            theWriter.writeNext(new String[]{"9a", "9b", "9c", "9d"});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

