/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import java.util.List;
import org.refcodes.data.Delimiter;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Record;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvEscapeMode;

public abstract class AbstractColumn<T>
implements Column<T>,
Cloneable {
    private final Class<T> _type;
    private final String _key;

    public AbstractColumn(String aKey, Class<T> aType) {
        this._key = aKey;
        this._type = aType;
    }

    @Override
    public String toStorageString(T aValue) {
        String[] theStorageStrings = this.toStorageStrings(aValue);
        if (theStorageStrings == null || theStorageStrings.length == 0) {
            return null;
        }
        if (theStorageStrings.length == 1 && !this.getType().isArray()) {
            return theStorageStrings[0];
        }
        if (this.getType().isArray()) {
            return new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(this.toStorageStrings(aValue)).withDelimiter(Delimiter.ARRAY.getChar()).toString();
        }
        throw new IllegalArgumentException("The type <" + this.getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + ((Object[])aValue).length + "> whereas only one element is being expected.");
    }

    @Override
    public T fromStorageString(String aStringValue) throws ParseException {
        if (!this.getType().isArray()) {
            return this.fromStorageStrings(new String[]{aStringValue});
        }
        List theFromSeparatedValues = new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(aStringValue).withDelimiter(Delimiter.ARRAY.getChar()).toFields();
        return this.fromStorageStrings(theFromSeparatedValues.toArray(new String[theFromSeparatedValues.size()]));
    }

    @Override
    public String toPrintable(T aValue) {
        if (aValue.getClass().isArray()) {
            return new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields((Object[])aValue).withDelimiter(Delimiter.ARRAY.getChar()).toString();
        }
        return aValue.toString();
    }

    @Override
    public boolean contains(Record<?> aRecord) {
        Object eValue;
        if (aRecord.containsKey(this.getKey()) && (eValue = aRecord.get(this.getKey())) != null) {
            return this.getType().isAssignableFrom(eValue.getClass());
        }
        return false;
    }

    @Override
    public T get(Record<?> aRecord) throws ColumnMismatchException {
        Object eValue;
        if (aRecord.containsKey(this.getKey()) && (eValue = aRecord.get(this.getKey())) != null) {
            if (this.getType().isAssignableFrom(eValue.getClass())) {
                return (T)eValue;
            }
            throw new ColumnMismatchException("The type <" + this.getType().getName() + "> for column with key \"" + this.getKey() + "\" does not match the value's type <" + eValue.getClass().getName() + ">!", this, eValue);
        }
        return null;
    }

    @Override
    public T remove(Record<?> aRecord) throws ColumnMismatchException {
        Object eValue;
        if (aRecord.containsKey(this.getKey()) && (eValue = aRecord.get(this.getKey())) != null) {
            if (this.getType().isAssignableFrom(eValue.getClass())) {
                aRecord.remove(this.getKey());
                return (T)eValue;
            }
            throw new ColumnMismatchException("The type <" + this.getType().getName() + "> for column with key \"" + this.getKey() + "\" does not match the value's type <" + eValue.getClass().getName() + ">!", this, eValue);
        }
        return null;
    }

    public Class<T> getType() {
        return this._type;
    }

    public String getKey() {
        return this._key;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

