/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Literal;
import org.refcodes.tabular.AbstractColumn;

public class BooleanColumn
extends AbstractColumn<Boolean> {
    public BooleanColumn(String aKey) {
        super(aKey, Boolean.class);
    }

    @Override
    public String[] toStorageStrings(Boolean aValue) {
        String[] stringArray = new String[1];
        stringArray[0] = aValue != null ? (aValue.booleanValue() ? Literal.TRUE.getValue() : Literal.FALSE.getValue()) : Literal.FALSE.getValue();
        return stringArray;
    }

    @Override
    public Boolean fromStorageStrings(String[] aStringValues) throws ParseException {
        if (aStringValues == null || aStringValues.length == 0) {
            return null;
        }
        if (aStringValues.length == 1) {
            if (aStringValues[0] == null) {
                return null;
            }
            if (BooleanLiterals.isTrue((String)aStringValues[0])) {
                return true;
            }
            if (BooleanLiterals.isFalse((String)aStringValues[0])) {
                return false;
            }
            return null;
        }
        throw new IllegalArgumentException("The type <" + this.getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + aStringValues.length + "> whereas only one element is being expected.");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

