/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.refcodes.tabular.AbstractColumn;
import org.refcodes.time.DateFormat;
import org.refcodes.time.DateFormats;
import org.refcodes.time.DateUtility;

public class DateColumn
extends AbstractColumn<Date> {
    private DateTimeFormatter[] _dateFormats;

    public DateColumn(String aKey) {
        this(aKey, DateFormats.DEFAULT_DATE_FORMATS.getDateFormats());
    }

    public DateColumn(String aKey, DateTimeFormatter ... aDateFormats) {
        super(aKey, Date.class);
        this._dateFormats = new DateTimeFormatter[aDateFormats.length];
        for (int i = 0; i < aDateFormats.length; ++i) {
            this._dateFormats[i] = aDateFormats[i];
        }
    }

    @Override
    public String[] toStorageStrings(Date aValue) {
        return new String[]{this._dateFormats[0].format(Instant.ofEpochMilli(aValue.getTime()))};
    }

    @Override
    public synchronized Date fromStorageStrings(String[] aStringValues) throws ParseException {
        if (aStringValues == null || aStringValues.length == 0) {
            return null;
        }
        if (aStringValues.length == 1) {
            if (aStringValues[0] == null) {
                return null;
            }
            try {
                return DateUtility.toDate((String)aStringValues[0], (DateTimeFormatter[])this._dateFormats);
            }
            catch (DateTimeException e) {
                TemporalAccessor theTemporal = DateFormat.NORM_DATE_FORMAT.getFormatter().parse(aStringValues[0]);
                Instant theInstant = Instant.from(theTemporal);
                return new Date(theInstant.toEpochMilli());
            }
        }
        throw new IllegalArgumentException("The type <" + this.getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + aStringValues.length + "> whereas only one element is being expected.");
    }

    @Override
    public String toPrintable(Date aValue) {
        Instant theInstant = Instant.ofEpochMilli(aValue.getTime());
        return this._dateFormats[0].format(theInstant);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

