/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import java.util.HashSet;
import org.refcodes.data.Text;
import org.refcodes.exception.Trap;
import org.refcodes.tabular.AbstractColumn;
import org.refcodes.tabular.PrintStackTrace;

public class ExceptionColumn
extends AbstractColumn<Throwable> {
    private PrintStackTrace _printStackTrace;

    public ExceptionColumn(String aKey) {
        this(aKey, PrintStackTrace.EXPLODED);
    }

    public ExceptionColumn(String aKey, PrintStackTrace aPrintStackTrace) {
        super(aKey, Throwable.class);
        this._printStackTrace = aPrintStackTrace;
    }

    @Override
    public String[] toStorageStrings(Throwable aValue) {
        switch (this._printStackTrace) {
            case COMPACT: {
                return new String[]{Trap.asMessage((Throwable)aValue) + ": " + ExceptionColumn.toStackTrace(aValue)};
            }
            case NONE: {
                return new String[]{Trap.asMessage((Throwable)aValue)};
            }
        }
        return new String[]{Trap.asMessage((Throwable)aValue) + ":\n" + ExceptionColumn.toStackTrace(aValue)};
    }

    @Override
    public synchronized Throwable fromStorageStrings(String[] aStringValues) throws ParseException {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    @Override
    public String toPrintable(Throwable aValue) {
        switch (this._printStackTrace) {
            case COMPACT: {
                return Trap.asMessage((Throwable)aValue) + ": " + ExceptionColumn.toStackTrace(aValue);
            }
            case NONE: {
                return Trap.asMessage((Throwable)aValue);
            }
        }
        return aValue.getMessage() + ":\n" + ExceptionColumn.toStackTrace(aValue);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static String toStackTrace(Throwable aThrowable) {
        Object eIndent = "";
        String theAppend = ">>";
        StringBuilder theBuffer = new StringBuilder();
        HashSet<Throwable> theThrowables = new HashSet<Throwable>();
        for (Throwable eThrowable = aThrowable; eThrowable != null && !theThrowables.contains(eThrowable); eThrowable = eThrowable.getCause()) {
            theThrowables.add(eThrowable);
            if (aThrowable != eThrowable) {
                theBuffer.append("\n");
            }
            theBuffer.append((String)eIndent + "> Exception <" + eThrowable.getClass().getName() + ">:\n");
            eIndent = (String)eIndent + ">>";
            for (int i = 0; i < eThrowable.getStackTrace().length; ++i) {
                StackTraceElement eElement = eThrowable.getStackTrace()[i];
                theBuffer.append((String)eIndent + " " + eElement.toString());
                if (i >= eThrowable.getStackTrace().length - 1) continue;
                theBuffer.append("\n");
            }
        }
        return theBuffer.toString();
    }
}

