/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.refcodes.tabular.Field;
import org.refcodes.tabular.FieldImpl;
import org.refcodes.tabular.Record;

public class RecordImpl<T>
extends LinkedHashMap<String, T>
implements Record<T> {
    private static final long serialVersionUID = 1L;

    public RecordImpl() {
    }

    @SafeVarargs
    public RecordImpl(Field<? extends T> ... aFields) {
        for (Field<? extends T> eField : aFields) {
            if (this.put((String)eField.getKey(), eField.getValue()) == null) continue;
            throw new IllegalArgumentException("A field with key \"" + (String)eField.getKey() + "\" already exists, cannot add a field with the same key twice.");
        }
    }

    public RecordImpl(List<Field<T>> aFields) {
        this(aFields.toArray(new Field[aFields.size()]));
    }

    @Override
    public Set<Field<T>> toFieldSet() {
        HashSet<Field<T>> theFieldSet = new HashSet<Field<T>>();
        for (String eKey : this.keySet()) {
            theFieldSet.add(new FieldImpl(eKey, this.get(eKey)));
        }
        return theFieldSet;
    }
}

