/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.util.ArrayList;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Row;

public class RowImpl<T>
extends ArrayList<T>
implements Row<T> {
    private static final long serialVersionUID = 1L;

    @SafeVarargs
    public RowImpl(T ... aValues) {
        for (T eValue : aValues) {
            this.add(eValue);
        }
    }

    @Override
    public T get(Header<T> aHeader, String aKey) throws HeaderMismatchException, ColumnMismatchException {
        int theIndex = aHeader.indexOf(aKey);
        if (theIndex == -1) {
            throw new HeaderMismatchException("Unknwon header key \"" + aKey + "\", no such column.", aKey);
        }
        if (theIndex > this.size() - 1) {
            throw new HeaderMismatchException("Header out of bounds index at <" + theIndex + "> for key \"" + aKey + "\" for row (size <" + this.size() + ">).", aKey);
        }
        Object theValue = this.get(theIndex);
        Column theColumn = (Column)aHeader.get(aKey);
        if (!theColumn.getType().isAssignableFrom(theValue.getClass())) {
            throw new ColumnMismatchException("Column type <" + theColumn.getType().getName() + "> mismatch for key \"" + (String)theColumn.getKey() + "\" with value <" + theValue.getClass().getName() + "> at index <" + theIndex + ">.", theColumn, theValue);
        }
        return (T)theValue;
    }
}

